/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class SystemOutLogExporter
implements LogExporter {
    private static final DateTimeFormatter ISO_FORMAT = DateTimeFormatter.ISO_DATE_TIME;

    public static SystemOutLogExporter create() {
        return new SystemOutLogExporter();
    }

    @Deprecated
    public SystemOutLogExporter() {
    }

    @Override
    public CompletableResultCode export(Collection<LogData> logs) {
        StringBuilder stringBuilder = new StringBuilder(60);
        for (LogData log : logs) {
            stringBuilder.setLength(0);
            SystemOutLogExporter.formatLog(stringBuilder, log);
            System.out.println(stringBuilder);
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    static void formatLog(StringBuilder stringBuilder, LogData log) {
        InstrumentationScopeInfo instrumentationScopeInfo = log.getInstrumentationScopeInfo();
        stringBuilder.append(ISO_FORMAT.format(Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(log.getEpochNanos())).atZone(ZoneOffset.UTC))).append(" ").append((Object)log.getSeverity()).append(" '").append(log.getBody().asString()).append("' : ").append(log.getSpanContext().getTraceId()).append(" ").append(log.getSpanContext().getSpanId()).append(" [scopeInfo: ").append(instrumentationScopeInfo.getName()).append(":").append(instrumentationScopeInfo.getVersion() == null ? "" : instrumentationScopeInfo.getVersion()).append("] ").append(log.getAttributes());
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }
}

