/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.windows;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public class WindowsStartScreenRecordingOptions
extends BaseStartScreenRecordingOptions<WindowsStartScreenRecordingOptions> {
    private Integer fps;
    private String videoFilter;
    private String preset;
    private Boolean captureCursor;
    private Boolean captureClicks;
    private String audioInput;

    public static WindowsStartScreenRecordingOptions startScreenRecordingOptions() {
        return new WindowsStartScreenRecordingOptions();
    }

    public WindowsStartScreenRecordingOptions withFps(int fps) {
        this.fps = fps;
        return this;
    }

    public WindowsStartScreenRecordingOptions enableCursorCapture() {
        this.captureCursor = true;
        return this;
    }

    public WindowsStartScreenRecordingOptions enableClicksCapture() {
        this.captureClicks = true;
        return this;
    }

    public WindowsStartScreenRecordingOptions withAudioInput(String audioInput) {
        this.audioInput = audioInput;
        return this;
    }

    public WindowsStartScreenRecordingOptions withVideoFilter(String videoFilter) {
        this.videoFilter = videoFilter;
        return this;
    }

    public WindowsStartScreenRecordingOptions withPreset(String preset) {
        this.preset = preset;
        return this;
    }

    @Override
    public WindowsStartScreenRecordingOptions withTimeLimit(Duration timeLimit) {
        return (WindowsStartScreenRecordingOptions)super.withTimeLimit(timeLimit);
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        builder.putAll(super.build());
        Optional.ofNullable(this.fps).map(x -> builder.put("fps", x));
        Optional.ofNullable(this.preset).map(x -> builder.put("preset", x));
        Optional.ofNullable(this.videoFilter).map(x -> builder.put("videoFilter", x));
        Optional.ofNullable(this.captureClicks).map(x -> builder.put("captureClicks", x));
        Optional.ofNullable(this.captureCursor).map(x -> builder.put("captureCursor", x));
        Optional.ofNullable(this.audioInput).map(x -> builder.put("audioInput", x));
        return builder.build();
    }
}

