/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ExecutesMethod;
import java.util.Map;
import org.openqa.selenium.DeviceRotation;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Response;

public interface SupportsRotation
extends WebDriver,
ExecutesMethod,
Rotatable {
    @Override
    default public DeviceRotation rotation() {
        Response response = this.execute("getScreenRotation");
        return new DeviceRotation((Map)response.getValue());
    }

    @Override
    default public void rotate(DeviceRotation rotation) {
        this.execute("setScreenRotation", rotation.parameters());
    }

    @Override
    default public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", ImmutableMap.of("orientation", orientation.value().toUpperCase()));
    }

    @Override
    default public ScreenOrientation getOrientation() {
        Response response = this.execute("getScreenOrientation");
        String orientation = String.valueOf(response.getValue());
        return ScreenOrientation.valueOf(orientation.toUpperCase());
    }
}

