/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.bys.builder;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByAll
extends org.openqa.selenium.support.pagefactory.ByAll {
    private final List<By> bys;

    private Function<SearchContext, Optional<WebElement>> getSearchingFunction(By by) {
        return input -> {
            try {
                return Optional.of(input.findElement(by));
            }
            catch (NoSuchElementException e) {
                return Optional.empty();
            }
        };
    }

    public ByAll(By[] bys) {
        super(bys);
        Preconditions.checkNotNull(bys);
        this.bys = Arrays.asList(bys);
        Preconditions.checkArgument(!this.bys.isEmpty(), "By array should not be empty");
    }

    @Override
    public WebElement findElement(SearchContext context) {
        return this.bys.stream().map(by -> this.getSearchingFunction((By)by).apply(context)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new NoSuchElementException("Cannot locate an element using " + this.toString()));
    }
}

