/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.appmanagement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.appmanagement.BaseInstallApplicationOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public class AndroidInstallApplicationOptions
extends BaseInstallApplicationOptions<AndroidInstallApplicationOptions> {
    private Boolean replace;
    private Duration timeout;
    private Boolean allowTestPackages;
    private Boolean useSdcard;
    private Boolean grantPermissions;

    public AndroidInstallApplicationOptions withReplaceEnabled() {
        this.replace = true;
        return this;
    }

    public AndroidInstallApplicationOptions withReplaceDisabled() {
        this.replace = false;
        return this;
    }

    public AndroidInstallApplicationOptions withTimeout(Duration timeout) {
        Preconditions.checkArgument(!Preconditions.checkNotNull(timeout).isNegative(), "The timeout value cannot be negative");
        this.timeout = timeout;
        return this;
    }

    public AndroidInstallApplicationOptions withAllowTestPackagesEnabled() {
        this.allowTestPackages = true;
        return this;
    }

    public AndroidInstallApplicationOptions withAllowTestPackagesDisabled() {
        this.allowTestPackages = false;
        return this;
    }

    public AndroidInstallApplicationOptions withUseSdcardEnabled() {
        this.useSdcard = true;
        return this;
    }

    public AndroidInstallApplicationOptions withUseSdcardDisabled() {
        this.useSdcard = false;
        return this;
    }

    public AndroidInstallApplicationOptions withGrantPermissionsEnabled() {
        this.grantPermissions = true;
        return this;
    }

    public AndroidInstallApplicationOptions withGrantPermissionsDisabled() {
        this.grantPermissions = false;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Optional.ofNullable(this.replace).map(x -> builder.put("replace", x));
        Optional.ofNullable(this.timeout).map(x -> builder.put("timeout", x.toMillis()));
        Optional.ofNullable(this.allowTestPackages).map(x -> builder.put("allowTestPackages", x));
        Optional.ofNullable(this.useSdcard).map(x -> builder.put("useSdcard", x));
        Optional.ofNullable(this.grantPermissions).map(x -> builder.put("grantPermissions", x));
        return builder.build();
    }
}

