/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public interface PushesFiles
extends ExecutesMethod {
    default public void pushFile(String remotePath, byte[] base64Data) {
        CommandExecutionHelper.execute((ExecutesMethod)this, MobileCommand.pushFileCommand(remotePath, base64Data));
    }

    default public void pushFile(String remotePath, File file) throws IOException {
        Preconditions.checkNotNull(file, "A reference to file should not be NULL");
        if (!file.exists()) {
            throw new IOException(String.format("The given file %s doesn't exist", file.getAbsolutePath()));
        }
        this.pushFile(remotePath, Base64.encodeBase64(FileUtils.readFileToByteArray(file)));
    }
}

