/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.appmanagement.ApplicationState;
import io.appium.java_client.appmanagement.BaseActivateApplicationOptions;
import io.appium.java_client.appmanagement.BaseInstallApplicationOptions;
import io.appium.java_client.appmanagement.BaseRemoveApplicationOptions;
import io.appium.java_client.appmanagement.BaseTerminateApplicationOptions;
import java.time.Duration;
import java.util.AbstractMap;
import javax.annotation.Nullable;

public interface InteractsWithApps
extends ExecutesMethod {
    default public void installApp(String appPath) {
        this.installApp(appPath, null);
    }

    default public void installApp(String appPath, @Nullable BaseInstallApplicationOptions options) {
        Object[] objectArray;
        String[] stringArray;
        if (options == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "appPath";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "appPath";
            stringArray = stringArray3;
            stringArray3[1] = "options";
        }
        String[] parameters = stringArray;
        if (options == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = appPath;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = appPath;
            objectArray = objectArray3;
            objectArray3[1] = options.build();
        }
        Object[] values = objectArray;
        CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.INSTALL_APP, MobileCommand.prepareArguments(parameters, values)));
    }

    default public boolean isAppInstalled(String bundleId) {
        return (Boolean)CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.IS_APP_INSTALLED, MobileCommand.prepareArguments("bundleId", bundleId)));
    }

    default public void runAppInBackground(Duration duration) {
        this.execute(MobileCommand.RUN_APP_IN_BACKGROUND, ImmutableMap.of("seconds", (double)duration.toMillis() / 1000.0));
    }

    default public boolean removeApp(String bundleId) {
        return this.removeApp(bundleId, null);
    }

    default public boolean removeApp(String bundleId, @Nullable BaseRemoveApplicationOptions options) {
        Object[] objectArray;
        String[] stringArray;
        if (options == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "bundleId";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "bundleId";
            stringArray = stringArray3;
            stringArray3[1] = "options";
        }
        String[] parameters = stringArray;
        if (options == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = bundleId;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = bundleId;
            objectArray = objectArray3;
            objectArray3[1] = options.build();
        }
        Object[] values = objectArray;
        return (Boolean)CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.REMOVE_APP, MobileCommand.prepareArguments(parameters, values)));
    }

    default public void activateApp(String bundleId) {
        this.activateApp(bundleId, null);
    }

    default public void activateApp(String bundleId, @Nullable BaseActivateApplicationOptions options) {
        Object[] objectArray;
        String[] stringArray;
        if (options == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "bundleId";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "bundleId";
            stringArray = stringArray3;
            stringArray3[1] = "options";
        }
        String[] parameters = stringArray;
        if (options == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = bundleId;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = bundleId;
            objectArray = objectArray3;
            objectArray3[1] = options.build();
        }
        Object[] values = objectArray;
        CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.ACTIVATE_APP, MobileCommand.prepareArguments(parameters, values)));
    }

    default public ApplicationState queryAppState(String bundleId) {
        return ApplicationState.ofCode((Long)CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.QUERY_APP_STATE, ImmutableMap.of("bundleId", bundleId))));
    }

    default public boolean terminateApp(String bundleId) {
        return this.terminateApp(bundleId, null);
    }

    default public boolean terminateApp(String bundleId, @Nullable BaseTerminateApplicationOptions options) {
        Object[] objectArray;
        String[] stringArray;
        if (options == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "bundleId";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "bundleId";
            stringArray = stringArray3;
            stringArray3[1] = "options";
        }
        String[] parameters = stringArray;
        if (options == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = bundleId;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = bundleId;
            objectArray = objectArray3;
            objectArray3[1] = options.build();
        }
        Object[] values = objectArray;
        return (Boolean)CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.TERMINATE_APP, MobileCommand.prepareArguments(parameters, values)));
    }
}

