/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.html5;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.remote.ExecuteMethod;

public class RemoteLocationContext
implements LocationContext {
    private final ExecuteMethod executeMethod;

    public RemoteLocationContext(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    @Override
    public Location location() {
        Map result = (Map)this.executeMethod.execute("getLocation", null);
        if (result == null) {
            return null;
        }
        return new Location(this.castToDouble((Number)result.get("latitude")), this.castToDouble((Number)result.get("longitude")), this.castToDouble((Number)result.get("altitude")));
    }

    private Double castToDouble(Number number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        if (number instanceof Long) {
            return number.doubleValue();
        }
        throw new RuntimeException("Can't convert to double: " + number);
    }

    @Override
    public void setLocation(Location location) {
        ImmutableMap<String, Location> args = ImmutableMap.of("location", location);
        this.executeMethod.execute("setLocation", args);
    }
}

