/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetryResourceAutoConfiguration;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class AutoConfiguredOpenTelemetrySdkBuilder
implements AutoConfigurationCustomizer {
    @Nullable
    private ConfigProperties config;
    private BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer = (a, unused) -> a;
    private BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer = (a, unused) -> a;
    private BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer = (a, unused) -> a;
    private BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer = (a, unused) -> a;
    private Supplier<Map<String, String>> propertiesSupplier = Collections::emptyMap;
    private ClassLoader serviceClassLoader = AutoConfiguredOpenTelemetrySdkBuilder.class.getClassLoader();
    private boolean setResultAsGlobal = true;
    private boolean customized;

    AutoConfiguredOpenTelemetrySdkBuilder() {
    }

    AutoConfiguredOpenTelemetrySdkBuilder setConfig(ConfigProperties config) {
        Objects.requireNonNull(config, "config");
        this.config = config;
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addPropagatorCustomizer(BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer) {
        Objects.requireNonNull(propagatorCustomizer, "propagatorCustomizer");
        this.propagatorCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.propagatorCustomizer, propagatorCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addResourceCustomizer(BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Objects.requireNonNull(resourceCustomizer, "resourceCustomizer");
        this.resourceCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.resourceCustomizer, resourceCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addSamplerCustomizer(BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer) {
        Objects.requireNonNull(samplerCustomizer, "samplerCustomizer");
        this.samplerCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.samplerCustomizer, samplerCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addSpanExporterCustomizer(BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer) {
        Objects.requireNonNull(spanExporterCustomizer, "spanExporterCustomizer");
        this.spanExporterCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.spanExporterCustomizer, spanExporterCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addPropertiesSupplier(Supplier<Map<String, String>> propertiesSupplier) {
        Objects.requireNonNull(propertiesSupplier, "propertiesSupplier");
        this.propertiesSupplier = AutoConfiguredOpenTelemetrySdkBuilder.mergeProperties(this.propertiesSupplier, propertiesSupplier);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder setResultAsGlobal(boolean setResultAsGlobal) {
        this.setResultAsGlobal = setResultAsGlobal;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        this.serviceClassLoader = serviceClassLoader;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdk build() {
        if (!this.customized) {
            this.customized = true;
            for (AutoConfigurationCustomizerProvider customizer2 : ServiceLoader.load(AutoConfigurationCustomizerProvider.class, this.serviceClassLoader)) {
                customizer2.customize(this);
            }
        }
        ConfigProperties config = this.getConfig();
        Resource resource = OpenTelemetryResourceAutoConfiguration.configureResource(config, this.resourceCustomizer);
        OpenTelemetrySdk sdk = OpenTelemetrySdkAutoConfiguration.newOpenTelemetrySdk(config, resource, this.serviceClassLoader, this.propagatorCustomizer, this.spanExporterCustomizer, this.samplerCustomizer, this.setResultAsGlobal);
        return AutoConfiguredOpenTelemetrySdk.create(sdk, resource, config);
    }

    private ConfigProperties getConfig() {
        ConfigProperties config = this.config;
        if (config == null) {
            config = DefaultConfigProperties.get(this.propertiesSupplier.get());
        }
        return config;
    }

    private static <I, O1, O2> BiFunction<I, ConfigProperties, O2> mergeCustomizer(BiFunction<? super I, ConfigProperties, ? extends O1> first, BiFunction<? super O1, ConfigProperties, ? extends O2> second) {
        return (configured, config) -> {
            Object firstResult = first.apply((Object)configured, (ConfigProperties)config);
            return second.apply((Object)firstResult, (ConfigProperties)config);
        };
    }

    private static Supplier<Map<String, String>> mergeProperties(Supplier<Map<String, String>> first, Supplier<Map<String, String>> second) {
        return () -> {
            HashMap merged = new HashMap();
            merged.putAll((Map)first.get());
            merged.putAll((Map)second.get());
            return merged;
        };
    }
}

