/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.screenrecording;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.screenrecording.BaseScreenRecordingOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public abstract class BaseStartScreenRecordingOptions<T extends BaseStartScreenRecordingOptions<T>>
extends BaseScreenRecordingOptions<BaseStartScreenRecordingOptions<T>> {
    private Boolean forceRestart;
    private Duration timeLimit;

    public T withTimeLimit(Duration timeLimit) {
        this.timeLimit = Preconditions.checkNotNull(timeLimit);
        return (T)this;
    }

    public T enableForcedRestart() {
        this.forceRestart = true;
        return (T)this;
    }

    public T disableForcedRestart() {
        this.forceRestart = false;
        return (T)this;
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        builder.putAll(super.build());
        Optional.ofNullable(this.timeLimit).map(x -> builder.put("timeLimit", x.getSeconds()));
        Optional.ofNullable(this.forceRestart).map(x -> builder.put("forceRestart", x));
        return builder.build();
    }
}

