/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.options.signing;

import io.appium.java_client.android.options.signing.KeystoreConfig;
import io.appium.java_client.internal.CapabilityHelpers;
import io.appium.java_client.remote.options.BaseOptions;
import io.appium.java_client.remote.options.CanSetCapability;
import java.util.Optional;
import org.openqa.selenium.Capabilities;

public interface SupportsKeystoreOptions<T extends BaseOptions<T>>
extends Capabilities,
CanSetCapability<T> {
    public static final String USE_KEYSTORE_OPTION = "useKeystore";
    public static final String KEYSTORE_PATH_OPTION = "keystorePath";
    public static final String KEYSTORE_PASSWORD_OPTION = "keystorePassword";
    public static final String KEY_ALIAS_OPTION = "keyAlias";
    public static final String KEY_PASSWORD_OPTION = "keyPassword";

    default public T setKeystoreConfig(KeystoreConfig keystoreConfig) {
        return this.amend(USE_KEYSTORE_OPTION, true).amend(KEYSTORE_PATH_OPTION, keystoreConfig.getPath()).amend(KEYSTORE_PASSWORD_OPTION, keystoreConfig.getPassword()).amend(KEY_ALIAS_OPTION, keystoreConfig.getKeyAlias()).amend(KEY_PASSWORD_OPTION, keystoreConfig.getKeyPassword());
    }

    default public Optional<Boolean> doesUseKeystore() {
        return Optional.ofNullable(CapabilityHelpers.toSafeBoolean(this.getCapability(USE_KEYSTORE_OPTION)));
    }

    default public Optional<KeystoreConfig> getKeystoreConfig() {
        if (!this.doesUseKeystore().orElse(false).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(new KeystoreConfig((String)this.getCapability(KEYSTORE_PATH_OPTION), (String)this.getCapability(KEYSTORE_PASSWORD_OPTION), (String)this.getCapability(KEY_ALIAS_OPTION), (String)this.getCapability(KEY_PASSWORD_OPTION)));
    }
}

