/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import org.openqa.selenium.internal.Require;

public class RemoteStatus {
    private final Map<String, Object> buildInfo;
    private final Map<String, Object> osInfo;

    public RemoteStatus(Map<String, Object> status) {
        Require.nonNull("Status", status);
        this.buildInfo = (Map)status.get("build");
        this.osInfo = (Map)status.get("os");
    }

    public String getReleaseLabel() {
        return (String)this.buildInfo.get("version");
    }

    public String getBuildRevision() {
        return (String)this.buildInfo.get("revision");
    }

    public String getBuildTime() {
        return (String)this.buildInfo.get("time");
    }

    public String getOsArch() {
        return (String)this.osInfo.get("arch");
    }

    public String getOsName() {
        return (String)this.osInfo.get("name");
    }

    public String getOsVersion() {
        return (String)this.osInfo.get("version");
    }

    public String toString() {
        return String.format("Build info: version: '%s', revision: '%s', time: '%s'%nOS info: arch: '%s', name: '%s', version: '%s'", this.getReleaseLabel(), this.getBuildRevision(), this.getBuildTime(), this.getOsArch(), this.getOsName(), this.getOsVersion());
    }
}

