/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.logs.LogEmitterBuilder;
import io.opentelemetry.sdk.logs.LogEmitterSharedState;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.SdkLogEmitter;
import io.opentelemetry.sdk.logs.SdkLogEmitterBuilder;
import io.opentelemetry.sdk.logs.SdkLogEmitterProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SdkLogEmitterProvider
implements Closeable {
    static final String DEFAULT_EMITTER_NAME = "unknown";
    private static final Logger LOGGER = Logger.getLogger(SdkLogEmitterProvider.class.getName());
    private final LogEmitterSharedState sharedState;
    private final ComponentRegistry<SdkLogEmitter> logEmitterComponentRegistry;

    public static SdkLogEmitterProviderBuilder builder() {
        return new SdkLogEmitterProviderBuilder();
    }

    SdkLogEmitterProvider(Resource resource, List<LogProcessor> processors, Clock clock) {
        this.sharedState = new LogEmitterSharedState(resource, processors, clock);
        this.logEmitterComponentRegistry = new ComponentRegistry<SdkLogEmitter>(instrumentationLibraryInfo -> new SdkLogEmitter(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
    }

    public LogEmitterBuilder logEmitterBuilder(String instrumentationName) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            LOGGER.fine("LogEmitter requested without instrumentation name.");
            instrumentationName = DEFAULT_EMITTER_NAME;
        }
        return new SdkLogEmitterBuilder(this.logEmitterComponentRegistry, instrumentationName);
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.log(Level.WARNING, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

