/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.screenrecording;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public class ScreenRecordingUploadOptions {
    private String remotePath;
    private String user;
    private String pass;
    private String method;
    private String fileFieldName;
    private Map<String, String> headers;
    private Map<String, Object> formFields;

    public static ScreenRecordingUploadOptions uploadOptions() {
        return new ScreenRecordingUploadOptions();
    }

    public ScreenRecordingUploadOptions withRemotePath(String remotePath) {
        this.remotePath = Preconditions.checkNotNull(remotePath);
        return this;
    }

    public ScreenRecordingUploadOptions withAuthCredentials(String user, String pass) {
        this.user = Preconditions.checkNotNull(user);
        this.pass = Preconditions.checkNotNull(pass);
        return this;
    }

    public ScreenRecordingUploadOptions withHttpMethod(RequestMethod method) {
        this.method = Preconditions.checkNotNull(method).name();
        return this;
    }

    public ScreenRecordingUploadOptions withFileFieldName(String fileFieldName) {
        this.fileFieldName = Preconditions.checkNotNull(fileFieldName);
        return this;
    }

    public ScreenRecordingUploadOptions withFormFields(Map<String, Object> formFields) {
        this.formFields = Preconditions.checkNotNull(formFields);
        return this;
    }

    public ScreenRecordingUploadOptions withHeaders(Map<String, String> headers) {
        this.headers = Preconditions.checkNotNull(headers);
        return this;
    }

    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Optional.ofNullable(this.remotePath).map(x -> builder.put("remotePath", x));
        Optional.ofNullable(this.user).map(x -> builder.put("user", x));
        Optional.ofNullable(this.pass).map(x -> builder.put("pass", x));
        Optional.ofNullable(this.method).map(x -> builder.put("method", x));
        Optional.ofNullable(this.fileFieldName).map(x -> builder.put("fileFieldName", x));
        Optional.ofNullable(this.formFields).map(x -> builder.put("formFields", x));
        Optional.ofNullable(this.headers).map(x -> builder.put("headers", x));
        return builder.build();
    }

    public static enum RequestMethod {
        POST,
        PUT;

    }
}

