/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.NoSuchContextException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Response;

public interface SupportsContextSwitching
extends WebDriver,
ContextAware,
ExecutesMethod {
    @Override
    default public WebDriver context(String name) {
        Preconditions.checkNotNull(name, "Must supply a context name");
        try {
            this.execute("switchToContext", ImmutableMap.of("name", name));
            return this;
        }
        catch (WebDriverException e) {
            throw new NoSuchContextException(e.getMessage(), e);
        }
    }

    @Override
    default public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles", ImmutableMap.of());
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, ex);
        }
    }

    @Override
    @Nullable
    default public String getContext() {
        String contextName = String.valueOf(this.execute("getCurrentContextHandle").getValue());
        return "null".equalsIgnoreCase(contextName) ? null : contextName;
    }
}

