/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.serverevents.CommandEvent;
import io.appium.java_client.serverevents.CustomEvent;
import io.appium.java_client.serverevents.ServerEvents;
import io.appium.java_client.serverevents.TimedEvent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Response;

public interface LogsEvents
extends ExecutesMethod {
    default public void logEvent(CustomEvent event) {
        this.execute(MobileCommand.LOG_EVENT, ImmutableMap.of("vendor", event.getVendor(), "event", event.getEventName()));
    }

    default public ServerEvents getEvents() {
        Response response = this.execute(MobileCommand.GET_EVENTS);
        String jsonData = new Json().toJson(response.getValue());
        Map value = (Map)response.getValue();
        List<CommandEvent> commands = ((List)value.get("commands")).stream().map(cmd -> new CommandEvent((String)cmd.get("cmd"), (Long)cmd.get("startTime"), (Long)cmd.get("endTime"))).collect(Collectors.toList());
        List<TimedEvent> events = value.keySet().stream().filter(name -> !name.equals("commands")).map(name -> new TimedEvent((String)name, (List)value.get(name))).collect(Collectors.toList());
        return new ServerEvents(commands, events, jsonData);
    }
}

