/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import io.appium.java_client.ComparesImages;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.imageio.ImageIO;

public class ScreenshotState {
    private static final Duration DEFAULT_INTERVAL_MS = Duration.ofMillis(500L);
    private BufferedImage previousScreenshot;
    private final Supplier<BufferedImage> stateProvider;
    private final ComparesImages comparator;
    private Duration comparisonInterval = DEFAULT_INTERVAL_MS;

    public ScreenshotState(ComparesImages comparator, Supplier<BufferedImage> stateProvider) {
        this.comparator = (ComparesImages)Preconditions.checkNotNull((Object)comparator);
        this.stateProvider = stateProvider;
    }

    public ScreenshotState(ComparesImages comparator) {
        this(comparator, null);
    }

    public Duration getComparisonInterval() {
        return this.comparisonInterval;
    }

    public ScreenshotState setComparisonInterval(Duration comparisonInterval) {
        this.comparisonInterval = comparisonInterval;
        return this;
    }

    public ScreenshotState remember() {
        this.previousScreenshot = this.stateProvider.get();
        return this;
    }

    public ScreenshotState remember(BufferedImage customInitialState) {
        this.previousScreenshot = (BufferedImage)Preconditions.checkNotNull((Object)customInitialState);
        return this;
    }

    private ScreenshotState checkState(Function<Double, Boolean> checkerFunc, Duration timeout) {
        double score;
        LocalDateTime started = LocalDateTime.now();
        do {
            BufferedImage currentState = this.stateProvider.get();
            score = this.getOverlapScore(Optional.ofNullable(this.previousScreenshot).orElseThrow(() -> new ScreenshotComparisonError("Initial screenshot state is not set. Nothing to compare")), currentState);
            if (checkerFunc.apply(score).booleanValue()) {
                return this;
            }
            try {
                Thread.sleep(this.comparisonInterval.toMillis());
            }
            catch (InterruptedException e) {
                throw new ScreenshotComparisonError(e);
            }
        } while (Duration.between(started, LocalDateTime.now()).compareTo(timeout) <= 0);
        throw new ScreenshotComparisonTimeout(String.format("Screenshot comparison timed out after %s ms. Actual similarity score: %.5f", timeout.toMillis(), score), score);
    }

    public ScreenshotState verifyChanged(Duration timeout, double minScore) {
        return this.checkState(x -> x < minScore, timeout);
    }

    public ScreenshotState verifyNotChanged(Duration timeout, double minScore) {
        return this.checkState(x -> x >= minScore, timeout);
    }

    /*
     * Loose catch block
     */
    public double getOverlapScore(BufferedImage refImage, BufferedImage tplImage) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                double d;
                ByteArrayOutputStream img2;
                ByteArrayOutputStream img1;
                block18: {
                    block17: {
                        img1 = new ByteArrayOutputStream();
                        img2 = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)refImage, "png", img1);
                        ImageIO.write((RenderedImage)tplImage, "png", img2);
                        d = this.comparator.getImagesSimilarity(Base64.getEncoder().encode(img1.toByteArray()), Base64.getEncoder().encode(img2.toByteArray())).getScore();
                        if (img2 == null) break block17;
                        img2.close();
                    }
                    if (img1 == null) break block18;
                    img1.close();
                }
                return d;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (img2 != null) {
                                img2.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (img1 != null) {
                                img1.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ScreenshotComparisonError(e);
        }
    }

    public static class ScreenshotComparisonError
    extends RuntimeException {
        private static final long serialVersionUID = -7011854909939194466L;

        ScreenshotComparisonError(Throwable reason) {
            super(reason);
        }

        ScreenshotComparisonError(String message) {
            super(message);
        }
    }

    public static class ScreenshotComparisonTimeout
    extends RuntimeException {
        private static final long serialVersionUID = 6336247721154252476L;
        private final double currentScore;

        ScreenshotComparisonTimeout(String message, double currentScore) {
            super(message);
            this.currentScore = currentScore;
        }

        public double getCurrentScore() {
            return this.currentScore;
        }
    }
}

