/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.android.GsmCallActions;
import io.appium.java_client.android.GsmSignalStrength;
import io.appium.java_client.android.GsmVoiceState;
import io.appium.java_client.android.NetworkSpeed;
import io.appium.java_client.android.PowerACState;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.internal.HasIdentity;

public class AndroidMobileCommandHelper
extends MobileCommand {
    public static Map.Entry<String, Map<String, ?>> currentActivityCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(CURRENT_ACTIVITY, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> currentPackageCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_CURRENT_PACKAGE, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> endTestCoverageCommand(String intent, String path) {
        String[] parameters = new String[]{"intent", "path"};
        Object[] values = new Object[]{intent, path};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(END_TEST_COVERAGE, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> getSupportedPerformanceDataTypesCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_SUPPORTED_PERFORMANCE_DATA_TYPES, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getPerformanceDataCommand(String packageName, String dataType, int dataReadTimeout) throws Exception {
        String[] parameters = new String[]{"packageName", "dataType", "dataReadTimeout"};
        Object[] values = new Object[]{packageName, dataType, dataReadTimeout};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(GET_PERFORMANCE_DATA, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> getDisplayDensityCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_DISPLAY_DENSITY, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getNetworkConnectionCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_NETWORK_CONNECTION, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getSystemBarsCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_SYSTEM_BARS, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> isLockedCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(IS_LOCKED, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> fingerPrintCommand(int fingerPrintId) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(FINGER_PRINT, AndroidMobileCommandHelper.prepareArguments("fingerprintId", fingerPrintId));
    }

    public static Map.Entry<String, Map<String, ?>> openNotificationsCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(OPEN_NOTIFICATIONS, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> setConnectionCommand(long bitMask) {
        String[] parameters = new String[]{"name", "parameters"};
        Object[] values = new Object[]{"network_connection", ImmutableMap.of((Object)"type", (Object)bitMask)};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(SET_NETWORK_CONNECTION, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> startActivityCommand(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, String intentAction, String intentCategory, String intentFlags, String optionalIntentArguments, boolean stopApp) throws IllegalArgumentException {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)appPackage) && !StringUtils.isBlank((CharSequence)appActivity) ? 1 : 0) != 0, (Object)String.format("'%s' and '%s' are required.", "appPackage", "appActivity"));
        String targetWaitPackage = !StringUtils.isBlank((CharSequence)appWaitPackage) ? appWaitPackage : "";
        String targetWaitActivity = !StringUtils.isBlank((CharSequence)appWaitActivity) ? appWaitActivity : "";
        String targetIntentAction = !StringUtils.isBlank((CharSequence)intentAction) ? intentAction : "";
        String targetIntentCategory = !StringUtils.isBlank((CharSequence)intentCategory) ? intentCategory : "";
        String targetIntentFlags = !StringUtils.isBlank((CharSequence)intentFlags) ? intentFlags : "";
        String targetOptionalIntentArguments = !StringUtils.isBlank((CharSequence)optionalIntentArguments) ? optionalIntentArguments : "";
        ImmutableMap parameters = ImmutableMap.builder().put((Object)"appPackage", (Object)appPackage).put((Object)"appActivity", (Object)appActivity).put((Object)"appWaitPackage", (Object)targetWaitPackage).put((Object)"appWaitActivity", (Object)targetWaitActivity).put((Object)"dontStopAppOnReset", (Object)(!stopApp ? 1 : 0)).put((Object)"intentAction", (Object)targetIntentAction).put((Object)"intentCategory", (Object)targetIntentCategory).put((Object)"intentFlags", (Object)targetIntentFlags).put((Object)"optionalIntentArguments", (Object)targetOptionalIntentArguments).build();
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(START_ACTIVITY, parameters);
    }

    public static Map.Entry<String, Map<String, ?>> toggleLocationServicesCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(TOGGLE_LOCATION_SERVICES, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> unlockCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(UNLOCK, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> replaceElementValueCommand(HasIdentity hasIdentityObject, String value) {
        String[] parameters = new String[]{"id", "value"};
        Object[] values = new Object[]{hasIdentityObject.getId(), value};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(REPLACE_VALUE, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> sendSMSCommand(String phoneNumber, String message) {
        ImmutableMap parameters = ImmutableMap.builder().put((Object)"phoneNumber", (Object)phoneNumber).put((Object)"message", (Object)message).build();
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(SEND_SMS, parameters);
    }

    public static Map.Entry<String, Map<String, ?>> gsmCallCommand(String phoneNumber, GsmCallActions gsmCallActions) {
        String[] parameters = new String[]{"phoneNumber", "action"};
        Object[] values = new Object[]{phoneNumber, gsmCallActions.name().toLowerCase()};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(GSM_CALL, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> gsmSignalStrengthCommand(GsmSignalStrength gsmSignalStrength) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(GSM_SIGNAL, AndroidMobileCommandHelper.prepareArguments("signalStrengh", gsmSignalStrength.ordinal()));
    }

    public static Map.Entry<String, Map<String, ?>> gsmVoiceCommand(GsmVoiceState gsmVoiceState) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(GSM_VOICE, AndroidMobileCommandHelper.prepareArguments("state", gsmVoiceState.name().toLowerCase()));
    }

    public static Map.Entry<String, Map<String, ?>> networkSpeedCommand(NetworkSpeed networkSpeed) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(NETWORK_SPEED, AndroidMobileCommandHelper.prepareArguments("netspeed", networkSpeed.name().toLowerCase()));
    }

    public static Map.Entry<String, Map<String, ?>> powerCapacityCommand(int percent) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(POWER_CAPACITY, AndroidMobileCommandHelper.prepareArguments("percent", percent));
    }

    public static Map.Entry<String, Map<String, ?>> powerACCommand(PowerACState powerACState) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(POWER_AC_STATE, AndroidMobileCommandHelper.prepareArguments("state", powerACState.name().toLowerCase()));
    }

    public static Map.Entry<String, Map<String, ?>> toggleWifiCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(TOGGLE_WIFI, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> toggleAirplaneCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(TOGGLE_AIRPLANE_MODE, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> toggleDataCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(TOGGLE_DATA, ImmutableMap.of());
    }
}

