/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public class IOSStartScreenRecordingOptions
extends BaseStartScreenRecordingOptions<IOSStartScreenRecordingOptions> {
    private String videoType;
    private String videoQuality;

    public static IOSStartScreenRecordingOptions startScreenRecordingOptions() {
        return new IOSStartScreenRecordingOptions();
    }

    public IOSStartScreenRecordingOptions withVideoType(VideoType videoType) {
        this.videoType = ((VideoType)((Object)Preconditions.checkNotNull((Object)((Object)videoType)))).name().toLowerCase();
        return this;
    }

    public IOSStartScreenRecordingOptions withVideoQuality(VideoQuality videoQuality) {
        this.videoQuality = ((VideoQuality)((Object)Preconditions.checkNotNull((Object)((Object)videoQuality)))).name().toLowerCase();
        return this;
    }

    @Override
    public IOSStartScreenRecordingOptions withTimeLimit(Duration timeLimit) {
        return (IOSStartScreenRecordingOptions)super.withTimeLimit(timeLimit);
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.build());
        Optional.ofNullable(this.videoType).map(x -> builder.put((Object)"videoType", x));
        Optional.ofNullable(this.videoQuality).map(x -> builder.put((Object)"videoQuality", x));
        return builder.build();
    }

    public static enum VideoQuality {
        LOW,
        MEDIUM,
        HIGH,
        PHOTO;

    }

    public static enum VideoType {
        H264,
        MP4,
        FMP4;

    }
}

