/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.utils;

import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.pagefactory.bys.ContentType;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;

public final class WebDriverUnpackUtility {
    private static final String NATIVE_APP_PATTERN = "NATIVE_APP";

    public static WebDriver unpackWebDriverFromSearchContext(SearchContext searchContext) {
        if (searchContext instanceof WebDriver) {
            return (WebDriver)searchContext;
        }
        if (searchContext instanceof WrapsDriver) {
            return WebDriverUnpackUtility.unpackWebDriverFromSearchContext(((WrapsDriver)searchContext).getWrappedDriver());
        }
        if (searchContext instanceof WrapsElement) {
            return WebDriverUnpackUtility.unpackWebDriverFromSearchContext(((WrapsElement)searchContext).getWrappedElement());
        }
        return null;
    }

    public static String getPlatform(WebDriver driver) {
        if (driver == null) {
            return null;
        }
        Class<?> driverClass = driver.getClass();
        if (AndroidDriver.class.isAssignableFrom(driverClass)) {
            return "Android";
        }
        if (IOSDriver.class.isAssignableFrom(driverClass)) {
            return "iOS";
        }
        if (HasCapabilities.class.isAssignableFrom(driverClass)) {
            return String.valueOf(((HasCapabilities)driver).getCapabilities().getCapability("platformName"));
        }
        return null;
    }

    public static String getAutomation(WebDriver driver) {
        if (driver == null) {
            return null;
        }
        if (HasCapabilities.class.isAssignableFrom(driver.getClass())) {
            return String.valueOf(((HasCapabilities)driver).getCapabilities().getCapability("automationName"));
        }
        return null;
    }

    public static ContentType getCurrentContentType(SearchContext context) {
        WebDriver driver = WebDriverUnpackUtility.unpackWebDriverFromSearchContext(context);
        if (!ContextAware.class.isAssignableFrom(driver.getClass())) {
            return ContentType.HTML_OR_DEFAULT;
        }
        ContextAware contextAware = (ContextAware)ContextAware.class.cast(driver);
        String currentContext = contextAware.getContext();
        if (currentContext.contains(NATIVE_APP_PATTERN)) {
            return ContentType.NATIVE_MOBILE_SPECIFIC;
        }
        return ContentType.HTML_OR_DEFAULT;
    }
}

