/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.events;

import io.appium.java_client.events.DefaultBeanConfiguration;
import io.appium.java_client.events.api.Listener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.openqa.selenium.WebDriver;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class EventFiringWebDriverFactory {
    public static <T extends WebDriver> T getEventFiringWebDriver(T driver) {
        return EventFiringWebDriverFactory.getEventFiringWebDriver(driver, Collections.emptyList());
    }

    public static <T extends WebDriver> T getEventFiringWebDriver(T driver, Listener ... listeners) {
        return EventFiringWebDriverFactory.getEventFiringWebDriver(driver, Arrays.asList(listeners));
    }

    public static <T extends WebDriver> T getEventFiringWebDriver(T driver, Collection<Listener> listeners) {
        ArrayList<Listener> listenerList = new ArrayList<Listener>();
        Iterator<Listener> providers = ServiceLoader.load(Listener.class).iterator();
        while (providers.hasNext()) {
            listenerList.add(providers.next());
        }
        listenerList.addAll(listeners);
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{DefaultBeanConfiguration.class});
        return (T)((WebDriver)context.getBean("webdriver", new Object[]{driver, listenerList, context}));
    }
}

