/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.android.Connection;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.internal.HasIdentity;

public class AndroidMobileCommandHelper
extends MobileCommand {
    public static Map.Entry<String, Map<String, ?>> currentActivityCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>("currentActivity", ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> endTestCoverageCommand(String intent, String path) {
        String[] parameters = new String[]{"intent", "path"};
        Object[] values = new Object[]{intent, path};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("endTestCoverage", AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> getNetworkConnectionCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>("getNetworkConnection", ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> isLockedCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>("isLocked", ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("pressKeyCode", AndroidMobileCommandHelper.prepareArguments("keycode", key));
    }

    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("pressKeyCode", AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("longPressKeyCode", AndroidMobileCommandHelper.prepareArguments("keycode", key));
    }

    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("longPressKeyCode", AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> openNotificationsCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>("openNotifications", ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> pushFileCommandCommand(String remotePath, byte[] base64Data) {
        String[] parameters = new String[]{"path", "data"};
        Object[] values = new Object[]{remotePath, base64Data};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("pushFile", AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> setConnectionCommand(Connection connection) {
        String[] parameters = new String[]{"name", "parameters"};
        Object[] values = new Object[]{"network_connection", ImmutableMap.of((Object)"type", (Object)connection.bitMask)};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("setNetworkConnection", AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> startActivityCommand(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, String intentAction, String intentCategory, String intentFlags, String optionalIntentArguments, boolean stopApp) throws IllegalArgumentException {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)appPackage) && !StringUtils.isBlank((CharSequence)appActivity) ? 1 : 0) != 0, (Object)String.format("'%s' and '%s' are required.", "appPackage", "appActivity"));
        String targetWaitPackage = !StringUtils.isBlank((CharSequence)appWaitPackage) ? appWaitPackage : "";
        String targetWaitActivity = !StringUtils.isBlank((CharSequence)appWaitActivity) ? appWaitActivity : "";
        String targetIntentAction = !StringUtils.isBlank((CharSequence)intentAction) ? intentAction : "";
        String targetIntentCategory = !StringUtils.isBlank((CharSequence)intentCategory) ? intentCategory : "";
        String targetIntentFlags = !StringUtils.isBlank((CharSequence)intentFlags) ? intentFlags : "";
        String targetOptionalIntentArguments = !StringUtils.isBlank((CharSequence)optionalIntentArguments) ? optionalIntentArguments : "";
        ImmutableMap parameters = ImmutableMap.builder().put((Object)"appPackage", (Object)appPackage).put((Object)"appActivity", (Object)appActivity).put((Object)"appWaitPackage", (Object)targetWaitPackage).put((Object)"appWaitActivity", (Object)targetWaitActivity).put((Object)"dontStopAppOnReset", (Object)(!stopApp ? 1 : 0)).put((Object)"intentAction", (Object)targetIntentAction).put((Object)"intentCategory", (Object)targetIntentCategory).put((Object)"intentFlags", (Object)targetIntentFlags).put((Object)"optionalIntentArguments", (Object)targetOptionalIntentArguments).build();
        return new AbstractMap.SimpleEntry<String, ImmutableMap>("startActivity", parameters);
    }

    public static Map.Entry<String, Map<String, ?>> toggleLocationServicesCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>("toggleLocationServices", ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> unlockCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>("unlock", ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> lockDeviceCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("lock", AndroidMobileCommandHelper.prepareArguments("seconds", 0));
    }

    public static Map.Entry<String, Map<String, ?>> replaceElementValueCommand(HasIdentity hasIdentityObject, String value) {
        String[] parameters = new String[]{"id", "value"};
        Object[] values = new Object[]{hasIdentityObject.getId(), value};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>("replaceValue", AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }
}

