/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.http.HttpMethod;

public class MobileCommand {
    protected static final String RESET = "reset";
    protected static final String GET_STRINGS = "getStrings";
    protected static final String SET_VALUE = "setValue";
    protected static final String PULL_FILE = "pullFile";
    protected static final String PULL_FOLDER = "pullFolder";
    protected static final String HIDE_KEYBOARD = "hideKeyboard";
    protected static final String RUN_APP_IN_BACKGROUND = "runAppInBackground";
    protected static final String PERFORM_TOUCH_ACTION = "performTouchAction";
    protected static final String PERFORM_MULTI_TOUCH = "performMultiTouch";
    protected static final String IS_APP_INSTALLED = "isAppInstalled";
    protected static final String INSTALL_APP = "installApp";
    protected static final String REMOVE_APP = "removeApp";
    protected static final String LAUNCH_APP = "launchApp";
    protected static final String CLOSE_APP = "closeApp";
    protected static final String LOCK = "lock";
    protected static final String COMPLEX_FIND = "complexFind";
    protected static final String GET_SETTINGS = "getSettings";
    protected static final String SET_SETTINGS = "setSettings";
    protected static final String GET_DEVICE_TIME = "getDeviceTime";
    protected static final String GET_SESSION = "getSession";
    protected static final String SHAKE = "shake";
    protected static final String CURRENT_ACTIVITY = "currentActivity";
    protected static final String END_TEST_COVERAGE = "endTestCoverage";
    protected static final String GET_NETWORK_CONNECTION = "getNetworkConnection";
    protected static final String IS_LOCKED = "isLocked";
    protected static final String LONG_PRESS_KEY_CODE = "longPressKeyCode";
    protected static final String OPEN_NOTIFICATIONS = "openNotifications";
    protected static final String PRESS_KEY_CODE = "pressKeyCode";
    protected static final String PUSH_FILE = "pushFile";
    protected static final String SET_NETWORK_CONNECTION = "setNetworkConnection";
    protected static final String START_ACTIVITY = "startActivity";
    protected static final String TOGGLE_LOCATION_SERVICES = "toggleLocationServices";
    protected static final String UNLOCK = "unlock";
    protected static final String REPLACE_VALUE = "replaceValue";
    public static final Map<String, CommandInfo> commandRepository = MobileCommand.createCommandRepository();

    private static Map<String, CommandInfo> createCommandRepository() {
        HashMap<String, CommandInfo> result = new HashMap<String, CommandInfo>();
        result.put(RESET, MobileCommand.postC("/session/:sessionId/appium/app/reset"));
        result.put(GET_STRINGS, MobileCommand.postC("/session/:sessionId/appium/app/strings"));
        result.put(SET_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/value"));
        result.put(PULL_FILE, MobileCommand.postC("/session/:sessionId/appium/device/pull_file"));
        result.put(PULL_FOLDER, MobileCommand.postC("/session/:sessionId/appium/device/pull_folder"));
        result.put(HIDE_KEYBOARD, MobileCommand.postC("/session/:sessionId/appium/device/hide_keyboard"));
        result.put(RUN_APP_IN_BACKGROUND, MobileCommand.postC("/session/:sessionId/appium/app/background"));
        result.put(PERFORM_TOUCH_ACTION, MobileCommand.postC("/session/:sessionId/touch/perform"));
        result.put(PERFORM_MULTI_TOUCH, MobileCommand.postC("/session/:sessionId/touch/multi/perform"));
        result.put(IS_APP_INSTALLED, MobileCommand.postC("/session/:sessionId/appium/device/app_installed"));
        result.put(INSTALL_APP, MobileCommand.postC("/session/:sessionId/appium/device/install_app"));
        result.put(REMOVE_APP, MobileCommand.postC("/session/:sessionId/appium/device/remove_app"));
        result.put(LAUNCH_APP, MobileCommand.postC("/session/:sessionId/appium/app/launch"));
        result.put(CLOSE_APP, MobileCommand.postC("/session/:sessionId/appium/app/close"));
        result.put(LOCK, MobileCommand.postC("/session/:sessionId/appium/device/lock"));
        result.put(COMPLEX_FIND, MobileCommand.postC("/session/:sessionId/appium/app/complex_find"));
        result.put(GET_SETTINGS, MobileCommand.getC("/session/:sessionId/appium/settings"));
        result.put(SET_SETTINGS, MobileCommand.postC("/session/:sessionId/appium/settings"));
        result.put(GET_DEVICE_TIME, MobileCommand.getC("/session/:sessionId/appium/device/system_time"));
        result.put(GET_SESSION, MobileCommand.getC("/session/:sessionId/"));
        result.put(SHAKE, MobileCommand.postC("/session/:sessionId/appium/device/shake"));
        result.put(CURRENT_ACTIVITY, MobileCommand.getC("/session/:sessionId/appium/device/current_activity"));
        result.put(END_TEST_COVERAGE, MobileCommand.postC("/session/:sessionId/appium/app/end_test_coverage"));
        result.put(GET_NETWORK_CONNECTION, MobileCommand.getC("/session/:sessionId/network_connection"));
        result.put(IS_LOCKED, MobileCommand.postC("/session/:sessionId/appium/device/is_locked"));
        result.put(LONG_PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/long_press_keycode"));
        result.put(OPEN_NOTIFICATIONS, MobileCommand.postC("/session/:sessionId/appium/device/open_notifications"));
        result.put(PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/press_keycode"));
        result.put(PUSH_FILE, MobileCommand.postC("/session/:sessionId/appium/device/push_file"));
        result.put(SET_NETWORK_CONNECTION, MobileCommand.postC("/session/:sessionId/network_connection"));
        result.put(START_ACTIVITY, MobileCommand.postC("/session/:sessionId/appium/device/start_activity"));
        result.put(TOGGLE_LOCATION_SERVICES, MobileCommand.postC("/session/:sessionId/appium/device/toggle_location_services"));
        result.put(UNLOCK, MobileCommand.postC("/session/:sessionId/appium/device/unlock"));
        result.put(REPLACE_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/replace_value"));
        return result;
    }

    public static CommandInfo getC(String url) {
        return new CommandInfo(url, HttpMethod.GET);
    }

    public static CommandInfo postC(String url) {
        return new CommandInfo(url, HttpMethod.POST);
    }

    public static CommandInfo deleteC(String url) {
        return new CommandInfo(url, HttpMethod.DELETE);
    }

    protected static ImmutableMap<String, Object> prepareArguments(String param, Object value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)param, value);
        return builder.build();
    }

    protected static ImmutableMap<String, Object> prepareArguments(String[] params, Object[] values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int i = 0;
        while (i < params.length) {
            if (!StringUtils.isBlank((CharSequence)params[i]) && values[i] != null) {
                builder.put((Object)params[i], values[i]);
            }
            ++i;
        }
        return builder.build();
    }
}

