/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.MobileBy;
import io.appium.java_client.pagefactory.AndroidFindBy;
import io.appium.java_client.pagefactory.AndroidFindBys;
import io.appium.java_client.pagefactory.iOSFindBy;
import io.appium.java_client.pagefactory.iOSFindBys;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.ByChained;

class AppiumAnnotations
extends Annotations {
    private static final List<String> METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            List objectClassMethodNames = AppiumAnnotations.getMethodNames(Object.class.getDeclaredMethods());
            this.addAll(objectClassMethodNames);
            List annotationClassMethodNames = AppiumAnnotations.getMethodNames(Annotation.class.getDeclaredMethods());
            annotationClassMethodNames.removeAll(objectClassMethodNames);
            this.addAll(annotationClassMethodNames);
        }
    };
    private static final Class<?>[] DEFAULT_ANNOTATION_METHOD_ARGUMENTS = new Class[0];
    private final Field mobileField;
    private final String platform;

    private static List<String> getMethodNames(Method[] methods) {
        ArrayList<String> names = new ArrayList<String>();
        for (Method m : methods) {
            names.add(m.getName());
        }
        return names;
    }

    AppiumAnnotations(Field field, String platform) {
        super(field);
        this.mobileField = field;
        this.platform = String.valueOf(platform).toUpperCase().trim();
    }

    private void assertValidAnnotations() {
        AndroidFindBy androidBy = this.mobileField.getAnnotation(AndroidFindBy.class);
        AndroidFindBys androidBys = this.mobileField.getAnnotation(AndroidFindBys.class);
        iOSFindBy iOSBy = this.mobileField.getAnnotation(iOSFindBy.class);
        iOSFindBys iOSBys = this.mobileField.getAnnotation(iOSFindBys.class);
        if (androidBy != null && androidBys != null) {
            throw new IllegalArgumentException("If you use a '@AndroidFindBy' annotation, you must not also use a '@AndroidFindBys' annotation");
        }
        if (iOSBy != null && iOSBys != null) {
            throw new IllegalArgumentException("If you use a '@iOSFindBy' annotation, you must not also use a '@iOSFindBys' annotation");
        }
    }

    private static Method[] prepareAnnotationMethods(Class<? extends Annotation> annotation) {
        List<String> targeAnnotationMethodNamesList = AppiumAnnotations.getMethodNames(annotation.getDeclaredMethods());
        targeAnnotationMethodNamesList.removeAll(METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ);
        Method[] result = new Method[targeAnnotationMethodNamesList.size()];
        for (String methodName : targeAnnotationMethodNamesList) {
            try {
                result[targeAnnotationMethodNamesList.indexOf((Object)methodName)] = annotation.getMethod(methodName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static String getFilledValue(Annotation mobileBy) {
        Method[] values;
        for (Method value : values = AppiumAnnotations.prepareAnnotationMethods(mobileBy.getClass())) {
            try {
                String strategyParameter = value.invoke((Object)mobileBy, new Object[0]).toString();
                if ("".equals(strategyParameter)) continue;
                return value.getName();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("@" + mobileBy.getClass().getSimpleName() + ": one of " + Strategies.strategiesNames().toString() + " should be filled");
    }

    private By getMobileBy(Annotation annotation, String valueName) {
        Strategies[] strategies;
        for (Strategies strategy : strategies = Strategies.values()) {
            if (!strategy.returnValueName().equals(valueName)) continue;
            return strategy.getBy(annotation);
        }
        throw new IllegalArgumentException("@" + annotation.getClass().getSimpleName() + ": There is an unknown strategy " + valueName);
    }

    private By getChainedMobileBy(Annotation[] annotations) {
        By[] byArray = new By[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            byArray[i] = this.getMobileBy(annotations[i], AppiumAnnotations.getFilledValue(annotations[i]));
        }
        return new ByChained(byArray);
    }

    public By buildBy() {
        this.assertValidAnnotations();
        AndroidFindBy androidBy = this.mobileField.getAnnotation(AndroidFindBy.class);
        if (androidBy != null && "Android".toUpperCase().equals(this.platform)) {
            return this.getMobileBy(androidBy, AppiumAnnotations.getFilledValue(androidBy));
        }
        AndroidFindBys androidBys = this.mobileField.getAnnotation(AndroidFindBys.class);
        if (androidBys != null && "Android".toUpperCase().equals(this.platform)) {
            return this.getChainedMobileBy(androidBys.value());
        }
        iOSFindBy iOSBy = this.mobileField.getAnnotation(iOSFindBy.class);
        if (iOSBy != null && "iOS".toUpperCase().equals(this.platform)) {
            return this.getMobileBy(iOSBy, AppiumAnnotations.getFilledValue(iOSBy));
        }
        iOSFindBys iOSBys = this.mobileField.getAnnotation(iOSFindBys.class);
        if (iOSBys != null && "iOS".toUpperCase().equals(this.platform)) {
            return this.getChainedMobileBy(iOSBys.value());
        }
        return super.buildBy();
    }

    private static enum Strategies {
        BYUIAUTOMATOR("uiAutomator"){

            @Override
            By getBy(Annotation annotation) {
                String value = Strategies.getValue(annotation, (Strategies)this);
                if (annotation.annotationType().equals(AndroidFindBy.class)) {
                    return MobileBy.AndroidUIAutomator(value);
                }
                if (annotation.annotationType().equals(iOSFindBy.class)) {
                    return MobileBy.IosUIAutomation(value);
                }
                return super.getBy(annotation);
            }
        }
        ,
        BYACCESSABILITY("accessibility"){

            @Override
            By getBy(Annotation annotation) {
                return MobileBy.AccessibilityId(Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYCLASSNAME("className"){

            @Override
            By getBy(Annotation annotation) {
                return By.className((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYID("id"){

            @Override
            By getBy(Annotation annotation) {
                return By.id((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYTAG("tagName"){

            @Override
            By getBy(Annotation annotation) {
                return By.tagName((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYNAME("name"){

            @Override
            By getBy(Annotation annotation) {
                return By.name((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYXPATH("xpath"){

            @Override
            By getBy(Annotation annotation) {
                return By.xpath((String)Strategies.getValue(annotation, (Strategies)this));
            }
        };

        private final String valueName;

        private String returnValueName() {
            return this.valueName;
        }

        private Strategies(String valueName) {
            this.valueName = valueName;
        }

        private static String[] strategiesNames() {
            Strategies[] strategies = Strategies.values();
            String[] result = new String[strategies.length];
            int i = 0;
            for (Strategies strategy : Strategies.values()) {
                result[i] = strategy.valueName;
                ++i;
            }
            return result;
        }

        private static String getValue(Annotation annotation, Strategies strategy) {
            try {
                Method m = annotation.getClass().getMethod(strategy.valueName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
                return m.invoke((Object)annotation, new Object[0]).toString();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        By getBy(Annotation annotation) {
            return null;
        }
    }
}

