/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MobileDriver;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;

public class MobileElement
extends RemoteWebElement {
    private String foundBy;
    protected FileDetector fileDetector;
    private WebElement webElement;
    private MobileDriver parent;

    public MobileElement(RemoteWebElement originalElement, MobileDriver parentDriver) {
        this.webElement = originalElement;
        this.id = originalElement.getId();
        this.parent = parentDriver;
        super.setParent((RemoteWebDriver)new FakeRemoteWebDriver());
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public WebElement findElementByIosUIAutomation(String using) {
        return this.findElement("-ios uiautomation", using);
    }

    public List<WebElement> findElementsByIosUIAutomation(String using) {
        return this.findElements("-ios uiautomation", using);
    }

    public WebElement findElementByAndroidUIAutomator(String using) {
        return this.findElement("-android uiautomator", using);
    }

    public List<WebElement> findElementsByAndroidUIAutomator(String using) {
        return this.findElements("-android uiautomator", using);
    }

    public WebElement findElementByAccessibilityId(String using) {
        return this.findElement("accessibility id", using);
    }

    public List<WebElement> findElementsByAccessibilityId(String using) {
        return this.findElements("accessibility id", using);
    }

    public void setValue(String value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)this.id).put((Object)"value", (Object)value);
        this.execute("setValue", (Map<String, ?>)builder.build());
    }

    protected Response execute(String command, Map<String, ?> parameters) {
        return this.parent.execute(command, parameters);
    }

    private class FakeRemoteWebDriver
    extends RemoteWebDriver {
    }
}

