/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.util;

import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.deps.kubernetes.api.model.ObjectReference;
import io.ap4k.deps.kubernetes.client.dsl.Resource;
import io.ap4k.deps.openshift.api.model.ImageStreamTag;
import io.ap4k.deps.openshift.api.model.SourceBuildStrategyFluent;
import io.ap4k.deps.openshift.client.DefaultOpenShiftClient;
import io.ap4k.deps.openshift.client.OpenShiftClient;
import io.ap4k.kubernetes.decorator.Decorator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OpenshiftUtils {
    private static final OpenShiftClient client = new DefaultOpenShiftClient();

    public static boolean waitForImageStreamTags(List<HasMetadata> items, long amount, TimeUnit timeUnit) {
        if (items == null || items.isEmpty()) {
            return true;
        }
        final ArrayList tags = new ArrayList();
        ((KubernetesListBuilder)((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).accept((Visitor)new Decorator<SourceBuildStrategyFluent>(){

            public void visit(SourceBuildStrategyFluent strategy) {
                ObjectReference from = strategy.buildFrom();
                if (from.getKind().equals("ImageStreamTag")) {
                    tags.add(from.getName());
                }
            }
        })).build();
        boolean tagsMissing = true;
        long started = System.currentTimeMillis();
        long elapsed = 0L;
        while (tagsMissing && elapsed < timeUnit.toMillis(amount) && !Thread.interrupted()) {
            tagsMissing = false;
            for (String tag : tags) {
                ImageStreamTag t = (ImageStreamTag)((Resource)client.imageStreamTags().withName(tag)).get();
                if (t != null) continue;
                tagsMissing = true;
            }
            if (!tagsMissing) continue;
            try {
                Thread.sleep(1000L);
                elapsed = System.currentTimeMillis() - started;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return !tagsMissing;
    }
}

