/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.hook;

import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.Secret;
import io.ap4k.deps.openshift.api.model.BuildConfig;
import io.ap4k.deps.openshift.api.model.ImageStream;
import io.ap4k.deps.openshift.client.DefaultOpenShiftClient;
import io.ap4k.deps.openshift.client.OpenShiftClient;
import io.ap4k.hook.ProjectHook;
import io.ap4k.openshift.config.S2iConfig;
import io.ap4k.openshift.util.OpenshiftUtils;
import io.ap4k.project.Project;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OcBuildHook
extends ProjectHook {
    private final String name;
    private final S2iConfig config;
    private final OpenShiftClient client = new DefaultOpenShiftClient();
    private final KubernetesList kubernetesList;

    public OcBuildHook(String name, S2iConfig config, Project project, KubernetesList kubernetesList) {
        super(project);
        this.name = name;
        this.config = config;
        this.kubernetesList = kubernetesList;
    }

    public void init() {
        List items = this.kubernetesList.getItems();
        items.stream().filter(i -> this.config.isAutoDeployEnabled() || i instanceof BuildConfig || i instanceof ImageStream || i instanceof Secret).forEach(i -> {
            HasMetadata item = (HasMetadata)this.client.resource(i).createOrReplace();
            System.out.println("Applied: " + item.getKind() + " " + i.getMetadata().getName());
        });
        OpenshiftUtils.waitForImageStreamTags(items, 2L, TimeUnit.MINUTES);
    }

    public void warmup() {
    }

    public void run() {
        if (!this.project.getBuildInfo().getOutputFile().getParent().toFile().exists()) {
            throw new IllegalStateException("Can't trigger binary build. " + this.project.getBuildInfo().getOutputFile().toAbsolutePath().toString() + " does not exist!");
        }
        this.exec(new String[]{"oc", "start-build", this.name, "--from-dir=" + this.project.getBuildInfo().getOutputFile().getParent().toAbsolutePath().toString(), "--follow"});
    }
}

