/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.handler;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.deps.kubernetes.api.model.EnvVar;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.openshift.api.model.BuildConfig;
import io.ap4k.deps.openshift.api.model.BuildConfigBuilder;
import io.ap4k.deps.openshift.api.model.BuildConfigFluent;
import io.ap4k.deps.openshift.api.model.BuildConfigSpecFluent;
import io.ap4k.deps.openshift.api.model.BuildOutputFluent;
import io.ap4k.deps.openshift.api.model.BuildStrategyFluent;
import io.ap4k.deps.openshift.api.model.ImageStream;
import io.ap4k.deps.openshift.api.model.ImageStreamBuilder;
import io.ap4k.deps.openshift.api.model.ImageStreamFluent;
import io.ap4k.deps.openshift.api.model.SourceBuildStrategyFluent;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.openshift.config.EditableS2iConfig;
import io.ap4k.openshift.config.S2iConfig;
import io.ap4k.openshift.decorator.AddBuildEnvDecorator;
import io.ap4k.utils.Images;

public class SourceToImageHandler
implements Handler<S2iConfig> {
    private static final String OPENSHIFT = "openshift";
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private final Resources resources;

    public SourceToImageHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 350;
    }

    public void handle(S2iConfig config) {
        this.resources.add(OPENSHIFT, (HasMetadata)this.createBuilderImageStream(config));
        this.resources.add(OPENSHIFT, (HasMetadata)this.createBuildConfig(config));
        this.resources.add(OPENSHIFT, (HasMetadata)this.createProjectImageStream());
        for (Env env : config.getEnvVars()) {
            this.resources.decorate(OPENSHIFT, (Decorator)new AddBuildEnvDecorator(env));
        }
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(S2iConfig.class) || type.equals(EditableS2iConfig.class);
    }

    public ImageStream createBuilderImageStream(S2iConfig config) {
        String repository = Images.getRepository((String)config.getBuilderImage());
        String name = !repository.contains("/") ? repository : repository.substring(repository.lastIndexOf("/") + 1);
        return ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(name)).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withDockerImageRepository(repository)).endSpec()).build();
    }

    public ImageStream createProjectImageStream() {
        return ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(this.resources.getName())).withLabels(this.resources.getLabels())).endMetadata()).build();
    }

    public BuildConfig createBuildConfig(S2iConfig config) {
        String builderRepository = Images.getRepository((String)config.getBuilderImage());
        String builderTag = Images.getTag((String)config.getBuilderImage());
        String builderName = !builderRepository.contains("/") ? builderRepository : builderRepository.substring(builderRepository.lastIndexOf("/") + 1);
        return ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyFluent.SourceStrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(this.resources.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind(IMAGESTREAMTAG)).withName(this.resources.getName() + ":" + this.resources.getVersion())).endTo()).endOutput()).withNewSource().withNewBinary().endBinary()).endSource()).withNewStrategy().withNewSourceStrategy().withEnv(new EnvVar[0])).withNewFrom().withKind(IMAGESTREAMTAG)).withName(builderName + ":" + builderTag)).endFrom()).endSourceStrategy()).endStrategy()).endSpec()).build();
    }
}

