/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.handler;

import io.ap4k.AbstractKubernetesHandler;
import io.ap4k.Resources;
import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.deps.kubernetes.api.model.EnvVarFluent;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.deps.kubernetes.api.model.PodSpec;
import io.ap4k.deps.kubernetes.api.model.PodSpecBuilder;
import io.ap4k.deps.kubernetes.api.model.PodSpecFluent;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpec;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.ap4k.deps.openshift.api.model.DeploymentConfig;
import io.ap4k.deps.openshift.api.model.DeploymentConfigBuilder;
import io.ap4k.deps.openshift.api.model.DeploymentConfigFluent;
import io.ap4k.deps.openshift.api.model.DeploymentConfigSpecFluent;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerPolicyFluent;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.openshift.config.EditableOpenshiftConfig;
import io.ap4k.openshift.config.OpenshiftConfig;
import io.ap4k.openshift.decorator.AddRouteDecorator;
import io.ap4k.openshift.decorator.ApplyDeploymentTriggerDecorator;
import io.ap4k.openshift.decorator.ApplyReplicasDecorator;
import java.util.Optional;

public class OpenshiftHandler
extends AbstractKubernetesHandler<OpenshiftConfig> {
    private static final String OPENSHIFT = "openshift";
    private static final String APP = "app";
    private static final String VERSION = "version";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private static final String IMAGECHANGE = "ImageChange";
    private static final String JAVA_APP_JAR = "JAVA_APP_JAR";

    public OpenshiftHandler() {
        super(new Resources());
    }

    public OpenshiftHandler(Resources resources) {
        super(resources);
    }

    public int order() {
        return 300;
    }

    public void handle(OpenshiftConfig config) {
        this.setApplicationInfo(config);
        Optional<DeploymentConfig> existingDeploymentConfig = this.resources.groups().getOrDefault(OPENSHIFT, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof DeploymentConfig).map(i -> (DeploymentConfig)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeploymentConfig.isPresent()) {
            this.resources.add(OPENSHIFT, (HasMetadata)this.createDeploymentConfig(config));
        }
        this.addDecorators(OPENSHIFT, config);
    }

    protected void addDecorators(String group, OpenshiftConfig config) {
        super.addDecorators(group, (KubernetesConfig)config);
        this.resources.decorate(group, (Decorator)new ApplyReplicasDecorator(config.getReplicas()));
        this.resources.decorate(group, (Decorator)new ApplyDeploymentTriggerDecorator(config.getName(), config.getName() + ":" + config.getVersion()));
        this.resources.decorate(group, (Decorator)new AddRouteDecorator(config, this.resources.getLabels()));
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(OpenshiftConfig.class) || type.equals(EditableOpenshiftConfig.class);
    }

    public DeploymentConfig createDeploymentConfig(OpenshiftConfig config) {
        return ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(config.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withNewReplicas(1)).withTemplate(this.createPodTemplateSpec(config))).withSelector(this.resources.getLabels())).addNewTrigger().withType(IMAGECHANGE)).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withContainerNames(new String[]{config.getName()})).withNewFrom().withKind(IMAGESTREAMTAG)).withName(config.getName() + ":" + config.getVersion())).endFrom()).endImageChangeParams()).endTrigger()).endSpec()).build();
    }

    public PodTemplateSpec createPodTemplateSpec(OpenshiftConfig config) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(OpenshiftHandler.createPodSpec(config))).withNewMetadata().withLabels(this.resources.getLabels())).endMetadata()).build();
    }

    public static PodSpec createPodSpec(OpenshiftConfig config) {
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(config.getName())).withImage("")).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).addNewEnv().withName(JAVA_APP_JAR)).withValue("/deployments/" + config.getProject().getBuildInfo().getOutputFile().getFileName().toString())).endEnv()).endContainer()).build();
    }
}

