/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.generator;

import io.ap4k.Generator;
import io.ap4k.SessionListener;
import io.ap4k.WithProject;
import io.ap4k.WithSession;
import io.ap4k.config.ConfigurationSupplier;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.openshift.adapter.OpenshiftConfigAdapter;
import io.ap4k.openshift.adapter.S2iConfigAdapter;
import io.ap4k.openshift.annotation.EnableS2iBuild;
import io.ap4k.openshift.annotation.OpenshiftApplication;
import io.ap4k.openshift.config.EditableOpenshiftConfig;
import io.ap4k.openshift.config.OpenshiftConfig;
import io.ap4k.openshift.config.OpenshiftConfigCustomAdapter;
import io.ap4k.openshift.config.S2iConfig;
import io.ap4k.openshift.config.S2iConfigBuilder;
import io.ap4k.openshift.configurator.ApplySourceToImageHook;
import io.ap4k.openshift.handler.SourceToImageHandler;
import io.ap4k.openshift.hook.OcBuildHook;
import io.ap4k.project.Project;
import java.nio.file.Path;
import java.util.Map;
import javax.lang.model.element.Element;

public interface S2iBuildGenerator
extends Generator,
SessionListener,
WithSession,
WithProject {
    public static final String DEFAULT_S2I_BUILDER_IMAGE = "fabric8/s2i-java:2.3";
    public static final S2iConfig DEFAULT_SOURCE_TO_IMAGE_CONFIG = ((S2iConfigBuilder)new S2iConfigBuilder().withBuilderImage("fabric8/s2i-java:2.3")).build();

    default public void add(Map map) {
        EditableOpenshiftConfig openshiftConfig = OpenshiftConfigAdapter.newBuilder((Map)map.get(OpenshiftApplication.class.getName())).build();
        this.on((ConfigurationSupplier<S2iConfig>)new ConfigurationSupplier((VisitableBuilder)S2iConfigAdapter.newBuilder(this.propertiesMap(map, EnableS2iBuild.class)).accept((Visitor)new ApplySourceToImageHook(openshiftConfig))));
    }

    default public void add(Element mainClass) {
        EnableS2iBuild enableS2iBuild = mainClass.getAnnotation(EnableS2iBuild.class);
        OpenshiftApplication openshiftApplication = mainClass.getAnnotation(OpenshiftApplication.class);
        EditableOpenshiftConfig openshiftConfig = OpenshiftConfigCustomAdapter.newBuilder(this.getProject(), openshiftApplication).build();
        this.on((ConfigurationSupplier<S2iConfig>)new ConfigurationSupplier((VisitableBuilder)S2iConfigAdapter.newBuilder(enableS2iBuild).accept((Visitor)new ApplySourceToImageHook(openshiftConfig))));
    }

    default public void on(ConfigurationSupplier<S2iConfig> config) {
        session.configurators().add(config);
        session.handlers().add(new SourceToImageHandler(session.resources()));
        session.addListener((SessionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void onClosed() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(OcBuildHook.class.getClassLoader());
            S2iConfig s2iConfig = session.configurators().get(S2iConfig.class).orElse(DEFAULT_SOURCE_TO_IMAGE_CONFIG);
            String name = session.configurators().get(OpenshiftConfig.class).map(c -> c.getName()).orElse(this.getProject().getBuildInfo().getName());
            if (s2iConfig.isAutoBuildEnabled() || s2iConfig.isAutoDeployEnabled()) {
                OcBuildHook hook = new OcBuildHook(name, s2iConfig, this.getProject(), (KubernetesList)session.getGeneratedResources().get("openshift"));
                hook.register();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    default public Path getOutputDirectory() {
        return this.getProject().getBuildInfo().getResourceOutputDir().resolve(Project.DEFAULT_AP4K_OUTPUT_DIR);
    }
}

