/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.decorator;

import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.openshift.api.model.DeploymentConfigSpecFluent;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.ap4k.deps.openshift.api.model.DeploymentTriggerPolicyFluent;
import io.ap4k.kubernetes.decorator.Decorator;

public class ApplyDeploymentTriggerDecorator
extends Decorator<DeploymentConfigSpecFluent<?>> {
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private static final String IMAGECHANGE = "ImageChange";
    private final String containerName;
    private final String imageStreamTag;
    private final Predicate<DeploymentTriggerPolicyBuilder> predicate;

    public ApplyDeploymentTriggerDecorator(String containerName, String imageStreamTag) {
        this.containerName = containerName;
        this.imageStreamTag = imageStreamTag;
        this.predicate = d -> d.hasImageChangeParams() != false && d.buildImageChangeParams().getContainerNames() != null && d.buildImageChangeParams().getContainerNames().contains(containerName);
    }

    public void visit(DeploymentConfigSpecFluent<?> deploymentConfigSpec) {
        DeploymentConfigSpecFluent.TriggersNested target = deploymentConfigSpec.buildMatchingTrigger(this.predicate) != null ? deploymentConfigSpec.editMatchingTrigger(this.predicate) : deploymentConfigSpec.addNewTrigger();
        ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)target.withType(IMAGECHANGE)).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withContainerNames(new String[]{this.containerName})).withNewFrom().withKind(IMAGESTREAMTAG)).withName(this.imageStreamTag)).endFrom()).endImageChangeParams()).endTrigger();
    }
}

