/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.decorator;

import io.ap4k.deps.kubernetes.api.model.BaseKubernetesListFluent;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.deps.openshift.api.model.RouteFluent;
import io.ap4k.deps.openshift.api.model.RouteSpecFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.openshift.config.OpenshiftConfig;
import io.ap4k.utils.Ports;
import io.ap4k.utils.Strings;
import java.util.Map;
import java.util.Optional;

@Description(value="Add a route to the list.")
public class AddRouteDecorator
extends Decorator<KubernetesListBuilder> {
    private final OpenshiftConfig config;
    private final Map<String, String> allLabels;

    public AddRouteDecorator(OpenshiftConfig config, Map<String, String> allLabels) {
        this.config = config;
        this.allLabels = allLabels;
    }

    public void visit(KubernetesListBuilder list) {
        Optional p = Ports.getHttpPort((KubernetesConfig)this.config);
        if (!p.isPresent() || Strings.isNullOrEmpty((String)this.config.getHost())) {
            return;
        }
        Port port = (Port)p.get();
        ((BaseKubernetesListFluent.RouteItemsNested)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((BaseKubernetesListFluent.RouteItemsNested)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)list.addNewRouteItem().withNewMetadata().withName(this.config.getName())).withLabels(this.allLabels)).endMetadata()).withNewSpec().withHost(this.config.getHost())).withPath(port.getPath())).withNewTo().withKind("Service")).withName(this.config.getName())).endTo()).withNewPort().withNewTargetPort(Integer.valueOf(port.getHostPort()))).endPort()).endSpec()).endRouteItem();
    }
}

