/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.openshift.config;

import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.ConfigurationFluentImpl;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.EnvBuilder;
import io.ap4k.kubernetes.config.EnvFluent;
import io.ap4k.kubernetes.config.EnvFluentImpl;
import io.ap4k.openshift.config.S2iConfig;
import io.ap4k.openshift.config.S2iConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S2iConfigFluentImpl<A extends S2iConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements S2iConfigFluent<A> {
    private String builderImage = "fabric8/s2i-java:2.3";
    private List<EnvBuilder> envVars = new ArrayList<EnvBuilder>();
    private boolean autoBuildEnabled = false;
    private boolean autoDeployEnabled = false;

    public S2iConfigFluentImpl() {
    }

    public S2iConfigFluentImpl(S2iConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withBuilderImage(instance.getBuilderImage());
        this.withEnvVars(instance.getEnvVars());
        this.withAutoBuildEnabled(instance.isAutoBuildEnabled());
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled());
    }

    @Override
    public String getBuilderImage() {
        return this.builderImage;
    }

    @Override
    public A withBuilderImage(String builderImage) {
        this.builderImage = builderImage;
        return (A)this;
    }

    @Override
    public Boolean hasBuilderImage() {
        return this.builderImage != null;
    }

    @Override
    public A withNewBuilderImage(String arg1) {
        return this.withBuilderImage(new String(arg1));
    }

    @Override
    public A withNewBuilderImage(StringBuilder arg1) {
        return this.withBuilderImage(new String(arg1));
    }

    @Override
    public A withNewBuilderImage(StringBuffer arg1) {
        return this.withBuilderImage(new String(arg1));
    }

    @Override
    public A withEnvVars(Env ... envVars) {
        if (this.envVars != null) {
            this.envVars.clear();
        }
        if (envVars != null) {
            for (Env item : envVars) {
                this.addToEnvVars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Env[] getEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnvVar(int index) {
        return this.envVars.get(index).build();
    }

    @Override
    public Env buildFirstEnvVar() {
        return this.envVars.get(0).build();
    }

    @Override
    public Env buildLastEnvVar() {
        return this.envVars.get(this.envVars.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.envVars.add(index >= 0 ? index : this.envVars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.envVars.size()) {
            this.envVars.add(builder);
        } else {
            this.envVars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvVars(Env ... items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvVars(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigEnvVars(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvVars() {
        return this.envVars != null && !this.envVars.isEmpty();
    }

    @Override
    public A addNewConfigEnvVar(String name, String value, String secret, String configmap, String field) {
        return this.addToEnvVars(new Env(name, value, secret, configmap, field));
    }

    @Override
    public S2iConfigFluent.ConfigEnvVarsNested<A> addNewConfigEnvVar() {
        return new ConfigEnvVarsNestedImpl();
    }

    @Override
    public S2iConfigFluent.ConfigEnvVarsNested<A> addNewEnvVarLike(Env item) {
        return new ConfigEnvVarsNestedImpl(-1, item);
    }

    @Override
    public S2iConfigFluent.ConfigEnvVarsNested<A> setNewEnvVarLike(int index, Env item) {
        return new ConfigEnvVarsNestedImpl(index, item);
    }

    @Override
    public S2iConfigFluent.ConfigEnvVarsNested<A> editEnvVar(int index) {
        if (this.envVars.size() <= index) {
            throw new RuntimeException("Can't edit envVars. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public S2iConfigFluent.ConfigEnvVarsNested<A> editFirstEnvVar() {
        if (this.envVars.size() == 0) {
            throw new RuntimeException("Can't edit first envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    @Override
    public S2iConfigFluent.ConfigEnvVarsNested<A> editLastEnvVar() {
        int index = this.envVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public S2iConfigFluent.ConfigEnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVars.size(); ++i) {
            if (!predicate.apply((Object)this.envVars.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVars. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public boolean isAutoBuildEnabled() {
        return this.autoBuildEnabled;
    }

    @Override
    public A withAutoBuildEnabled(boolean autoBuildEnabled) {
        this.autoBuildEnabled = autoBuildEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasAutoBuildEnabled() {
        return true;
    }

    @Override
    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    @Override
    public A withAutoDeployEnabled(boolean autoDeployEnabled) {
        this.autoDeployEnabled = autoDeployEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasAutoDeployEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S2iConfigFluentImpl that = (S2iConfigFluentImpl)o;
        if (this.builderImage != null ? !this.builderImage.equals(that.builderImage) : that.builderImage != null) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        if (this.autoBuildEnabled != that.autoBuildEnabled) {
            return false;
        }
        return this.autoDeployEnabled == that.autoDeployEnabled;
    }

    public class ConfigEnvVarsNestedImpl<N>
    extends EnvFluentImpl<S2iConfigFluent.ConfigEnvVarsNested<N>>
    implements S2iConfigFluent.ConfigEnvVarsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        ConfigEnvVarsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder((EnvFluent)this, item);
        }

        ConfigEnvVarsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder((EnvFluent)this);
        }

        @Override
        public N and() {
            return (N)S2iConfigFluentImpl.this.setToEnvVars(this.index, (Env)this.builder.build());
        }

        @Override
        public N endConfigEnvVar() {
            return this.and();
        }
    }
}

