/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.Env;
import io.ap4k.component.model.EnvBuilder;
import io.ap4k.component.model.EnvFluentImpl;
import io.ap4k.component.model.Kind;
import io.ap4k.component.model.LinkSpec;
import io.ap4k.component.model.LinkSpecFluent;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinkSpecFluentImpl<A extends LinkSpecFluent<A>>
extends BaseFluent<A>
implements LinkSpecFluent<A> {
    private String componentName;
    private Kind kind;
    private String ref;
    private List<EnvBuilder> envs;

    public LinkSpecFluentImpl() {
    }

    public LinkSpecFluentImpl(LinkSpec instance) {
        this.withComponentName(instance.getComponentName());
        this.withKind(instance.getKind());
        this.withRef(instance.getRef());
        this.withEnvs(instance.getEnvs());
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public A withComponentName(String componentName) {
        this.componentName = componentName;
        return (A)this;
    }

    @Override
    public Boolean hasComponentName() {
        return this.componentName != null;
    }

    @Override
    public A withNewComponentName(String arg1) {
        return this.withComponentName(new String(arg1));
    }

    @Override
    public A withNewComponentName(StringBuilder arg1) {
        return this.withComponentName(new String(arg1));
    }

    @Override
    public A withNewComponentName(StringBuffer arg1) {
        return this.withComponentName(new String(arg1));
    }

    @Override
    public Kind getKind() {
        return this.kind;
    }

    @Override
    public A withKind(Kind kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public A withRef(String ref) {
        this.ref = ref;
        return (A)this;
    }

    @Override
    public Boolean hasRef() {
        return this.ref != null;
    }

    @Override
    public A withNewRef(String arg1) {
        return this.withRef(new String(arg1));
    }

    @Override
    public A withNewRef(StringBuilder arg1) {
        return this.withRef(new String(arg1));
    }

    @Override
    public A withNewRef(StringBuffer arg1) {
        return this.withRef(new String(arg1));
    }

    @Override
    public A withEnvs(Env ... envs) {
        if (this.envs != null) {
            this.envs.clear();
        }
        if (envs != null) {
            for (Env item : envs) {
                this.addToEnvs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Env[] getEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnv(int index) {
        return this.envs.get(index).build();
    }

    @Override
    public Env buildFirstEnv() {
        return this.envs.get(0).build();
    }

    @Override
    public Env buildLastEnv() {
        return this.envs.get(this.envs.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.envs.add(index >= 0 ? index : this.envs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.envs.size()) {
            this.envs.add(builder);
        } else {
            this.envs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvs(Env ... items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvs(Collection<Env> items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvs(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvs(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvs() {
        return this.envs != null && !this.envs.isEmpty();
    }

    @Override
    public A addNewEnv(String name, String value) {
        return this.addToEnvs(new Env(name, value));
    }

    @Override
    public LinkSpecFluent.EnvsNested<A> addNewEnv() {
        return new EnvsNestedImpl();
    }

    @Override
    public LinkSpecFluent.EnvsNested<A> addNewEnvLike(Env item) {
        return new EnvsNestedImpl(-1, item);
    }

    @Override
    public LinkSpecFluent.EnvsNested<A> setNewEnvLike(int index, Env item) {
        return new EnvsNestedImpl(index, item);
    }

    @Override
    public LinkSpecFluent.EnvsNested<A> editEnv(int index) {
        if (this.envs.size() <= index) {
            throw new RuntimeException("Can't edit envs. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public LinkSpecFluent.EnvsNested<A> editFirstEnv() {
        if (this.envs.size() == 0) {
            throw new RuntimeException("Can't edit first envs. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public LinkSpecFluent.EnvsNested<A> editLastEnv() {
        int index = this.envs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envs. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public LinkSpecFluent.EnvsNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envs.size(); ++i) {
            if (!predicate.apply((Object)this.envs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envs. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinkSpecFluentImpl that = (LinkSpecFluentImpl)o;
        if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals((Object)that.kind) : that.kind != null) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        return !(this.envs != null ? !this.envs.equals(that.envs) : that.envs != null);
    }

    public class EnvsNestedImpl<N>
    extends EnvFluentImpl<LinkSpecFluent.EnvsNested<N>>
    implements LinkSpecFluent.EnvsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        EnvsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        EnvsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder(this);
        }

        @Override
        public N and() {
            return (N)LinkSpecFluentImpl.this.setToEnvs(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

