/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.Component;
import io.ap4k.component.model.ComponentFluent;
import io.ap4k.component.model.ComponentSpec;
import io.ap4k.component.model.ComponentSpecBuilder;
import io.ap4k.component.model.ComponentSpecFluentImpl;
import io.ap4k.component.model.ComponentStatus;
import io.ap4k.component.model.ComponentStatusBuilder;
import io.ap4k.component.model.ComponentStatusFluentImpl;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.model.ObjectMeta;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaFluent;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaFluentImpl;

public class ComponentFluentImpl<A extends ComponentFluent<A>>
extends BaseFluent<A>
implements ComponentFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ComponentSpecBuilder spec;
    private ComponentStatusBuilder status;

    public ComponentFluentImpl() {
    }

    public ComponentFluentImpl(Component instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ComponentFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ComponentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ComponentFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ComponentFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ComponentFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ComponentSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ComponentSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ComponentSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new ComponentSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ComponentFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ComponentFluent.SpecNested<A> withNewSpecLike(ComponentSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ComponentFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ComponentFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ComponentSpecBuilder().build());
    }

    @Override
    public ComponentFluent.SpecNested<A> editOrNewSpecLike(ComponentSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ComponentStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ComponentStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ComponentStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new ComponentStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public A withNewStatus(String phase) {
        return this.withStatus(new ComponentStatus(phase));
    }

    @Override
    public ComponentFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ComponentFluent.StatusNested<A> withNewStatusLike(ComponentStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ComponentFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ComponentFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ComponentStatusBuilder().build());
    }

    @Override
    public ComponentFluent.StatusNested<A> editOrNewStatusLike(ComponentStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentFluentImpl that = (ComponentFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends ComponentStatusFluentImpl<ComponentFluent.StatusNested<N>>
    implements ComponentFluent.StatusNested<N>,
    Nested<N> {
        private final ComponentStatusBuilder builder;

        StatusNestedImpl(ComponentStatus item) {
            this.builder = new ComponentStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ComponentStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ComponentSpecFluentImpl<ComponentFluent.SpecNested<N>>
    implements ComponentFluent.SpecNested<N>,
    Nested<N> {
        private final ComponentSpecBuilder builder;

        SpecNestedImpl(ComponentSpec item) {
            this.builder = new ComponentSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ComponentSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ComponentFluent.MetadataNested<N>>
    implements ComponentFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ComponentFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

