/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.Capability;
import io.ap4k.component.model.CapabilityBuilder;
import io.ap4k.component.model.CapabilityFluentImpl;
import io.ap4k.component.model.CapabilityList;
import io.ap4k.component.model.CapabilityListFluent;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CapabilityListFluentImpl<A extends CapabilityListFluent<A>>
extends BaseFluent<A>
implements CapabilityListFluent<A> {
    private String apiVersion;
    private List<CapabilityBuilder> items;
    private String kind;
    private ListMeta metadata;

    public CapabilityListFluentImpl() {
    }

    public CapabilityListFluentImpl(CapabilityList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, Capability item) {
        if (this.items == null) {
            this.items = new ArrayList<CapabilityBuilder>();
        }
        CapabilityBuilder builder = new CapabilityBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Capability item) {
        if (this.items == null) {
            this.items = new ArrayList<CapabilityBuilder>();
        }
        CapabilityBuilder builder = new CapabilityBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Capability ... items) {
        if (this.items == null) {
            this.items = new ArrayList<CapabilityBuilder>();
        }
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Capability> items) {
        if (this.items == null) {
            this.items = new ArrayList<CapabilityBuilder>();
        }
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Capability ... items) {
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Capability> items) {
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Capability> getItems() {
        return CapabilityListFluentImpl.build(this.items);
    }

    @Override
    public List<Capability> buildItems() {
        return CapabilityListFluentImpl.build(this.items);
    }

    @Override
    public Capability buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Capability buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Capability buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Capability buildMatchingItem(Predicate<CapabilityBuilder> predicate) {
        for (CapabilityBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<CapabilityBuilder> predicate) {
        for (CapabilityBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Capability> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<CapabilityBuilder>();
            for (Capability item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<CapabilityBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(Capability ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Capability item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public CapabilityListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public CapabilityListFluent.ItemsNested<A> addNewItemLike(Capability item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public CapabilityListFluent.ItemsNested<A> setNewItemLike(int index, Capability item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public CapabilityListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public CapabilityListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public CapabilityListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public CapabilityListFluent.ItemsNested<A> editMatchingItem(Predicate<CapabilityBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CapabilityListFluentImpl that = (CapabilityListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends CapabilityFluentImpl<CapabilityListFluent.ItemsNested<N>>
    implements CapabilityListFluent.ItemsNested<N>,
    Nested<N> {
        private final CapabilityBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Capability item) {
            this.index = index;
            this.builder = new CapabilityBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new CapabilityBuilder(this);
        }

        @Override
        public N and() {
            return (N)CapabilityListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

