/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.handler;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.component.config.CompositeConfig;
import io.ap4k.component.config.EditableCompositeConfig;
import io.ap4k.component.decorator.AddEnvToComponentDecorator;
import io.ap4k.component.decorator.AddRuntimeTypeToComponentDecorator;
import io.ap4k.component.decorator.AddRuntimeVersionToComponentDecorator;
import io.ap4k.component.model.Component;
import io.ap4k.component.model.ComponentBuilder;
import io.ap4k.component.model.ComponentFluent;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.kubernetes.config.ConfigKey;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.utils.Strings;

public class ComponentHandler
implements Handler<CompositeConfig> {
    public static final ConfigKey<String> RUNTIME_TYPE = new ConfigKey("RUNTIME_TYPE", String.class);
    public static final ConfigKey<String> RUNTIME_VERSION = new ConfigKey("RUNTIME_VERSION", String.class);
    private final Resources resources;

    public ComponentHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 1100;
    }

    public void handle(CompositeConfig config) {
        if (Strings.isNullOrEmpty((String)this.resources.getName())) {
            this.resources.setName(config.getName());
        }
        this.resources.addCustom("component", (HasMetadata)this.createComponent(config));
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(CompositeConfig.class) || type.equals(EditableCompositeConfig.class);
    }

    private void addVisitors(CompositeConfig config) {
        String type = (String)config.getAttribute(RUNTIME_TYPE);
        String version = (String)config.getAttribute(RUNTIME_VERSION);
        if (type != null) {
            this.resources.decorateCustom("component", (Decorator)new AddRuntimeTypeToComponentDecorator(type));
        }
        if (version != null) {
            this.resources.decorateCustom("component", (Decorator)new AddRuntimeVersionToComponentDecorator(version));
        }
        for (Env env : config.getEnvs()) {
            this.resources.decorateCustom("component", (Decorator)new AddEnvToComponentDecorator(env));
        }
    }

    private Component createComponent(CompositeConfig config) {
        String version;
        ComponentFluent.SpecNested specBuilder = ((ComponentBuilder)((ComponentFluent.MetadataNested)((ComponentFluent.MetadataNested)new ComponentBuilder().withNewMetadata().withName(this.resources.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec();
        String type = (String)config.getAttribute(RUNTIME_TYPE);
        if (type != null) {
            specBuilder.withRuntime(type);
        }
        if ((version = (String)config.getAttribute(RUNTIME_VERSION)) != null) {
            specBuilder.withVersion(version);
        } else {
            specBuilder.withVersion(this.resources.getVersion());
        }
        for (Env env : config.getEnvs()) {
            specBuilder.addNewEnv(env.getName(), env.getValue());
        }
        return ((ComponentBuilder)((ComponentFluent.SpecNested)((ComponentFluent.SpecNested)specBuilder.withDeploymentMode(config.getDeploymentMode())).withExposeService(config.isExposeService())).endSpec()).build();
    }
}

