/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.config;

import io.ap4k.component.config.LinkConfig;
import io.ap4k.component.config.LinkConfigFluent;
import io.ap4k.component.model.Kind;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.ConfigurationFluentImpl;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.EnvBuilder;
import io.ap4k.kubernetes.config.EnvFluent;
import io.ap4k.kubernetes.config.EnvFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinkConfigFluentImpl<A extends LinkConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements LinkConfigFluent<A> {
    private String name = "";
    private String componentName;
    private Kind kind = Kind.Env;
    private String ref = "";
    private List<EnvBuilder> envs = new ArrayList<EnvBuilder>();

    public LinkConfigFluentImpl() {
    }

    public LinkConfigFluentImpl(LinkConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withName(instance.getName());
        this.withComponentName(instance.getComponentName());
        this.withKind(instance.getKind());
        this.withRef(instance.getRef());
        this.withEnvs(instance.getEnvs());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public A withComponentName(String componentName) {
        this.componentName = componentName;
        return (A)this;
    }

    @Override
    public Boolean hasComponentName() {
        return this.componentName != null;
    }

    @Override
    public A withNewComponentName(String arg1) {
        return this.withComponentName(new String(arg1));
    }

    @Override
    public A withNewComponentName(StringBuilder arg1) {
        return this.withComponentName(new String(arg1));
    }

    @Override
    public A withNewComponentName(StringBuffer arg1) {
        return this.withComponentName(new String(arg1));
    }

    @Override
    public Kind getKind() {
        return this.kind;
    }

    @Override
    public A withKind(Kind kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public A withRef(String ref) {
        this.ref = ref;
        return (A)this;
    }

    @Override
    public Boolean hasRef() {
        return this.ref != null;
    }

    @Override
    public A withNewRef(String arg1) {
        return this.withRef(new String(arg1));
    }

    @Override
    public A withNewRef(StringBuilder arg1) {
        return this.withRef(new String(arg1));
    }

    @Override
    public A withNewRef(StringBuffer arg1) {
        return this.withRef(new String(arg1));
    }

    @Override
    public A withEnvs(Env ... envs) {
        if (this.envs != null) {
            this.envs.clear();
        }
        if (envs != null) {
            for (Env item : envs) {
                this.addToEnvs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Env[] getEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnv(int index) {
        return this.envs.get(index).build();
    }

    @Override
    public Env buildFirstEnv() {
        return this.envs.get(0).build();
    }

    @Override
    public Env buildLastEnv() {
        return this.envs.get(this.envs.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.envs.add(index >= 0 ? index : this.envs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.envs.size()) {
            this.envs.add(builder);
        } else {
            this.envs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvs(Env ... items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigEnvs(Collection<Env> items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvs(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigEnvs(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvs() {
        return this.envs != null && !this.envs.isEmpty();
    }

    @Override
    public A addNewConfigEnv(String name, String value, String secret, String configmap, String field) {
        return this.addToEnvs(new Env(name, value, secret, configmap, field));
    }

    @Override
    public LinkConfigFluent.ConfigEnvsNested<A> addNewConfigEnv() {
        return new ConfigEnvsNestedImpl();
    }

    @Override
    public LinkConfigFluent.ConfigEnvsNested<A> addNewEnvLike(Env item) {
        return new ConfigEnvsNestedImpl(-1, item);
    }

    @Override
    public LinkConfigFluent.ConfigEnvsNested<A> setNewEnvLike(int index, Env item) {
        return new ConfigEnvsNestedImpl(index, item);
    }

    @Override
    public LinkConfigFluent.ConfigEnvsNested<A> editEnv(int index) {
        if (this.envs.size() <= index) {
            throw new RuntimeException("Can't edit envs. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public LinkConfigFluent.ConfigEnvsNested<A> editFirstEnv() {
        if (this.envs.size() == 0) {
            throw new RuntimeException("Can't edit first envs. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public LinkConfigFluent.ConfigEnvsNested<A> editLastEnv() {
        int index = this.envs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envs. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public LinkConfigFluent.ConfigEnvsNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envs.size(); ++i) {
            if (!predicate.apply((Object)this.envs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envs. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinkConfigFluentImpl that = (LinkConfigFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals((Object)that.kind) : that.kind != null) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        return !(this.envs != null ? !this.envs.equals(that.envs) : that.envs != null);
    }

    public class ConfigEnvsNestedImpl<N>
    extends EnvFluentImpl<LinkConfigFluent.ConfigEnvsNested<N>>
    implements LinkConfigFluent.ConfigEnvsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        ConfigEnvsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder((EnvFluent)this, item);
        }

        ConfigEnvsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder((EnvFluent)this);
        }

        @Override
        public N and() {
            return (N)LinkConfigFluentImpl.this.setToEnvs(this.index, (Env)this.builder.build());
        }

        @Override
        public N endConfigEnv() {
            return this.and();
        }
    }
}

