/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.ComponentSpec;
import io.ap4k.component.model.ComponentSpecFluent;
import io.ap4k.component.model.DeploymentMode;
import io.ap4k.component.model.Env;
import io.ap4k.component.model.EnvBuilder;
import io.ap4k.component.model.EnvFluentImpl;
import io.ap4k.component.model.Storage;
import io.ap4k.component.model.StorageBuilder;
import io.ap4k.component.model.StorageFluentImpl;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentSpecFluentImpl<A extends ComponentSpecFluent<A>>
extends BaseFluent<A>
implements ComponentSpecFluent<A> {
    private DeploymentMode deploymentMode;
    private String runtime;
    private String version;
    private boolean exposeService;
    private StorageBuilder storage;
    private List<EnvBuilder> envs;

    public ComponentSpecFluentImpl() {
    }

    public ComponentSpecFluentImpl(ComponentSpec instance) {
        this.withDeploymentMode(instance.getDeploymentMode());
        this.withRuntime(instance.getRuntime());
        this.withVersion(instance.getVersion());
        this.withExposeService(instance.isExposeService());
        this.withStorage(instance.getStorage());
        this.withEnvs(instance.getEnvs());
    }

    @Override
    public DeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    @Override
    public A withDeploymentMode(DeploymentMode deploymentMode) {
        this.deploymentMode = deploymentMode;
        return (A)this;
    }

    @Override
    public Boolean hasDeploymentMode() {
        return this.deploymentMode != null;
    }

    @Override
    public String getRuntime() {
        return this.runtime;
    }

    @Override
    public A withRuntime(String runtime) {
        this.runtime = runtime;
        return (A)this;
    }

    @Override
    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    @Override
    public A withNewRuntime(String arg1) {
        return this.withRuntime(new String(arg1));
    }

    @Override
    public A withNewRuntime(StringBuilder arg1) {
        return this.withRuntime(new String(arg1));
    }

    @Override
    public A withNewRuntime(StringBuffer arg1) {
        return this.withRuntime(new String(arg1));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A withNewVersion(String arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuilder arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuffer arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public boolean isExposeService() {
        return this.exposeService;
    }

    @Override
    public A withExposeService(boolean exposeService) {
        this.exposeService = exposeService;
        return (A)this;
    }

    @Override
    public Boolean hasExposeService() {
        return true;
    }

    @Override
    @Deprecated
    public Storage getStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public Storage buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public A withStorage(Storage storage) {
        this._visitables.remove(this.storage);
        if (storage != null) {
            this.storage = new StorageBuilder(storage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public A withNewStorage(String name, String capacity, String mode) {
        return this.withStorage(new Storage(name, capacity, mode));
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> withNewStorage() {
        return new StorageNestedImpl();
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> withNewStorageLike(Storage item) {
        return new StorageNestedImpl(item);
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> editStorage() {
        return this.withNewStorageLike(this.getStorage());
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : new StorageBuilder().build());
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> editOrNewStorageLike(Storage item) {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : item);
    }

    @Override
    public A withEnvs(Env ... envs) {
        if (this.envs != null) {
            this.envs.clear();
        }
        if (envs != null) {
            for (Env item : envs) {
                this.addToEnvs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Env[] getEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnv(int index) {
        return this.envs.get(index).build();
    }

    @Override
    public Env buildFirstEnv() {
        return this.envs.get(0).build();
    }

    @Override
    public Env buildLastEnv() {
        return this.envs.get(this.envs.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.envs.add(index >= 0 ? index : this.envs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.envs.size()) {
            this.envs.add(builder);
        } else {
            this.envs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvs(Env ... items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvs(Collection<Env> items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvs(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvs(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvs() {
        return this.envs != null && !this.envs.isEmpty();
    }

    @Override
    public A addNewEnv(String name, String value) {
        return this.addToEnvs(new Env(name, value));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> addNewEnv() {
        return new EnvsNestedImpl();
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> addNewEnvLike(Env item) {
        return new EnvsNestedImpl(-1, item);
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> setNewEnvLike(int index, Env item) {
        return new EnvsNestedImpl(index, item);
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editEnv(int index) {
        if (this.envs.size() <= index) {
            throw new RuntimeException("Can't edit envs. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editFirstEnv() {
        if (this.envs.size() == 0) {
            throw new RuntimeException("Can't edit first envs. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editLastEnv() {
        int index = this.envs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envs. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envs.size(); ++i) {
            if (!predicate.apply((Object)this.envs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envs. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentSpecFluentImpl that = (ComponentSpecFluentImpl)o;
        if (this.deploymentMode != null ? !this.deploymentMode.equals((Object)that.deploymentMode) : that.deploymentMode != null) {
            return false;
        }
        if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.exposeService != that.exposeService) {
            return false;
        }
        if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) {
            return false;
        }
        return !(this.envs != null ? !this.envs.equals(that.envs) : that.envs != null);
    }

    public class EnvsNestedImpl<N>
    extends EnvFluentImpl<ComponentSpecFluent.EnvsNested<N>>
    implements ComponentSpecFluent.EnvsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        EnvsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        EnvsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.setToEnvs(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }

    public class StorageNestedImpl<N>
    extends StorageFluentImpl<ComponentSpecFluent.StorageNested<N>>
    implements ComponentSpecFluent.StorageNested<N>,
    Nested<N> {
        private final StorageBuilder builder;

        StorageNestedImpl(Storage item) {
            this.builder = new StorageBuilder(this, item);
        }

        StorageNestedImpl() {
            this.builder = new StorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.withStorage(this.builder.build());
        }

        @Override
        public N endStorage() {
            return this.and();
        }
    }
}

