/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.handler;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.component.config.EditableLinkConfig;
import io.ap4k.component.config.LinkConfig;
import io.ap4k.component.model.Link;
import io.ap4k.component.model.LinkBuilder;
import io.ap4k.component.model.LinkFluent;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.utils.Strings;

public class LinkHandler
implements Handler<LinkConfig> {
    private final Resources resources;

    LinkHandler() {
        this(new Resources());
    }

    public LinkHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 1200;
    }

    public void handle(LinkConfig config) {
        if (Strings.isNullOrEmpty((String)this.resources.getName())) {
            this.resources.setName(config.getName());
        }
        this.resources.addCustom("component", (HasMetadata)this.createLink(config));
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(LinkConfig.class) || type.equals(EditableLinkConfig.class);
    }

    private Link createLink(LinkConfig config) {
        LinkFluent.SpecNested linkSpec = (LinkFluent.SpecNested)((LinkFluent.SpecNested)((LinkFluent.SpecNested)((LinkBuilder)((LinkFluent.MetadataNested)new LinkBuilder().withNewMetadata().withName(config.getName())).endMetadata()).withNewSpec().withComponentName(config.getComponentName())).withKind(config.getKind())).withNewRef(config.getRef());
        for (Env env : config.getEnvs()) {
            linkSpec.addNewEnv(env.getName(), env.getValue());
        }
        return ((LinkBuilder)linkSpec.endSpec()).build();
    }
}

