/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.handler;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.component.model.Capability;
import io.ap4k.component.model.CapabilityBuilder;
import io.ap4k.component.model.CapabilityFluent;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.servicecatalog.config.EditableServiceCatalogConfig;
import io.ap4k.servicecatalog.config.Parameter;
import io.ap4k.servicecatalog.config.ServiceCatalogConfig;
import io.ap4k.servicecatalog.config.ServiceCatalogInstance;

public class ComponentServiceCatalogHandler
implements Handler<ServiceCatalogConfig> {
    private final Resources resources;

    ComponentServiceCatalogHandler() {
        this(new Resources());
    }

    public ComponentServiceCatalogHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 650;
    }

    public void handle(ServiceCatalogConfig config) {
        for (ServiceCatalogInstance instance : config.getInstances()) {
            this.resources.addCustom("component", (HasMetadata)this.createServiceInstance(instance));
        }
    }

    private Capability createServiceInstance(ServiceCatalogInstance instance) {
        return ((CapabilityBuilder)((CapabilityFluent.SpecNested)((CapabilityFluent.SpecNested)((CapabilityFluent.SpecNested)((CapabilityFluent.SpecNested)((CapabilityBuilder)((CapabilityFluent.MetadataNested)new CapabilityBuilder().withNewMetadata().withName(instance.getName())).endMetadata()).withNewSpec().withServiceClass(instance.getServiceClass())).withServicePlan(instance.getServicePlan())).withSecretName(instance.getBindingSecret())).withParameters(this.convertToModelParameter(instance.getParameters()))).endSpec()).build();
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(ServiceCatalogConfig.class) || type.equals(EditableServiceCatalogConfig.class);
    }

    private io.ap4k.component.model.Parameter[] convertToModelParameter(Parameter[] parametersConfig) {
        io.ap4k.component.model.Parameter[] parameters = new io.ap4k.component.model.Parameter[parametersConfig.length];
        for (int i = 0; i < parametersConfig.length; ++i) {
            Parameter paramConfig = parametersConfig[i];
            io.ap4k.component.model.Parameter parameter = new io.ap4k.component.model.Parameter();
            parameter.setName(paramConfig.getKey());
            parameter.setValue(paramConfig.getValue());
            parameters[i] = parameter;
        }
        return parameters;
    }
}

