/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.handler;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.component.decorator.AddServiceInstanceToComponentDecorator;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.servicecatalog.config.EditableServiceCatalogConfig;
import io.ap4k.servicecatalog.config.ServiceCatalogConfig;
import io.ap4k.servicecatalog.config.ServiceCatalogInstance;

public class ComponentServiceCatalogHandler
implements Handler<ServiceCatalogConfig> {
    private static final String COMPONENT = "component";
    private final Resources resources;

    ComponentServiceCatalogHandler() {
        this(new Resources());
    }

    public ComponentServiceCatalogHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 650;
    }

    public void handle(ServiceCatalogConfig config) {
        for (ServiceCatalogInstance instance : config.getInstances()) {
            this.resources.decorateCustom(COMPONENT, (Decorator)new AddServiceInstanceToComponentDecorator(instance));
        }
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(ServiceCatalogConfig.class) || type.equals(EditableServiceCatalogConfig.class);
    }
}

