/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.handler;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.component.config.CompositeConfig;
import io.ap4k.component.config.EditableCompositeConfig;
import io.ap4k.component.config.Link;
import io.ap4k.component.decorator.AddEnvToComponentDecorator;
import io.ap4k.component.decorator.AddLinkToComponentDecorator;
import io.ap4k.component.decorator.AddRuntimeTypeToComponentDecorator;
import io.ap4k.component.decorator.AddRuntimeVersionToComponentDecorator;
import io.ap4k.component.model.Component;
import io.ap4k.component.model.ComponentBuilder;
import io.ap4k.component.model.ComponentFluent;
import io.ap4k.component.model.DeploymentType;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.kubernetes.config.ConfigKey;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.utils.Strings;

public class ComponentHandler
implements Handler<CompositeConfig> {
    private static final String COMPONENT = "component";
    public static final ConfigKey<String> RUNTIME_TYPE = new ConfigKey("RUNTIME_TYPE", String.class);
    public static final ConfigKey<String> RUNTIME_VERSION = new ConfigKey("RUNTIME_VERSION", String.class);
    private final Resources resources;

    public ComponentHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 1100;
    }

    public void handle(CompositeConfig config) {
        if (Strings.isNullOrEmpty((String)this.resources.getName())) {
            this.resources.setName(config.getName());
        }
        this.resources.addCustom(COMPONENT, (HasMetadata)this.createComponent(config));
        this.addVisitors(config);
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(CompositeConfig.class) || type.equals(EditableCompositeConfig.class);
    }

    private void addVisitors(CompositeConfig config) {
        String type = (String)config.getAttribute(RUNTIME_TYPE);
        String version = (String)config.getAttribute(RUNTIME_VERSION);
        if (type != null) {
            this.resources.decorateCustom(COMPONENT, (Decorator)new AddRuntimeTypeToComponentDecorator(type));
        }
        if (version != null) {
            this.resources.decorateCustom(COMPONENT, (Decorator)new AddRuntimeVersionToComponentDecorator(version));
        }
        for (Env env : config.getEnvVars()) {
            this.resources.decorateCustom(COMPONENT, (Decorator)new AddEnvToComponentDecorator(env));
        }
        for (Link link : config.getLinks()) {
            this.resources.decorateCustom(COMPONENT, (Decorator)new AddLinkToComponentDecorator(link));
        }
    }

    private Component createComponent(CompositeConfig config) {
        return ((ComponentBuilder)((ComponentFluent.SpecNested)((ComponentFluent.SpecNested)((ComponentFluent.SpecNested)((ComponentBuilder)((ComponentFluent.MetadataNested)((ComponentFluent.MetadataNested)new ComponentBuilder().withNewMetadata().withName(this.resources.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withDeploymentMode(DeploymentType.innerloop)).withExposeService(config.isExposeService())).withVersion(this.resources.getVersion())).endSpec()).build();
    }
}

