/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.decorator;

import io.ap4k.component.model.ComponentSpecBuilder;
import io.ap4k.component.model.ComponentSpecFluent;
import io.ap4k.component.model.Parameter;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.servicecatalog.config.ServiceCatalogInstance;
import java.util.Arrays;

@Description(value="Add the service instance information to the component.")
public class AddServiceInstanceToComponentDecorator
extends Decorator<ComponentSpecBuilder> {
    private final ServiceCatalogInstance instance;

    public AddServiceInstanceToComponentDecorator(ServiceCatalogInstance instance) {
        this.instance = instance;
    }

    public void visit(ComponentSpecBuilder component) {
        if (this.hasService(component)) {
            return;
        }
        ((ComponentSpecFluent.ServicesNested)((ComponentSpecFluent.ServicesNested)((ComponentSpecFluent.ServicesNested)((ComponentSpecFluent.ServicesNested)((ComponentSpecFluent.ServicesNested)component.addNewService().withName(this.instance.getName())).withServiceClass(this.instance.getServiceClass())).withServicePlan(this.instance.getServicePlan())).withSecretName(this.instance.getBindingSecret())).withParameters(this.convertToModelParameter(this.instance.getParameters()))).endService();
    }

    private boolean hasService(ComponentSpecBuilder componentSpec) {
        return Arrays.asList(componentSpec.getServices()).stream().filter(s -> s.getName().equals(this.instance.getName())).count() > 0L;
    }

    private Parameter[] convertToModelParameter(io.ap4k.servicecatalog.config.Parameter[] parametersConfig) {
        Parameter[] parameters = new Parameter[parametersConfig.length];
        for (int i = 0; i < parametersConfig.length; ++i) {
            io.ap4k.servicecatalog.config.Parameter paramConfig = parametersConfig[i];
            Parameter parameter = new Parameter();
            parameter.setName(paramConfig.getKey());
            parameter.setValue(paramConfig.getValue());
            parameters[i] = parameter;
        }
        return parameters;
    }
}

