/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.config;

import io.ap4k.component.config.CompositeConfig;
import io.ap4k.component.config.CompositeConfigFluent;
import io.ap4k.component.config.Link;
import io.ap4k.component.config.LinkBuilder;
import io.ap4k.component.config.LinkFluentImpl;
import io.ap4k.component.model.DeploymentType;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.ConfigurationFluentImpl;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.EnvBuilder;
import io.ap4k.kubernetes.config.EnvFluent;
import io.ap4k.kubernetes.config.EnvFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompositeConfigFluentImpl<A extends CompositeConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements CompositeConfigFluent<A> {
    private String name = "";
    private DeploymentType deploymentType = DeploymentType.innerloop;
    private boolean exposeService = false;
    private List<EnvBuilder> envVars = new ArrayList<EnvBuilder>();
    private List<LinkBuilder> links = new ArrayList<LinkBuilder>();

    public CompositeConfigFluentImpl() {
    }

    public CompositeConfigFluentImpl(CompositeConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withName(instance.getName());
        this.withDeploymentType(instance.getDeploymentType());
        this.withExposeService(instance.isExposeService());
        this.withEnvVars(instance.getEnvVars());
        this.withLinks(instance.getLinks());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public A withDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
        return (A)this;
    }

    @Override
    public Boolean hasDeploymentType() {
        return this.deploymentType != null;
    }

    @Override
    public boolean isExposeService() {
        return this.exposeService;
    }

    @Override
    public A withExposeService(boolean exposeService) {
        this.exposeService = exposeService;
        return (A)this;
    }

    @Override
    public Boolean hasExposeService() {
        return true;
    }

    @Override
    public A withEnvVars(Env ... envVars) {
        if (this.envVars != null) {
            this.envVars.clear();
        }
        if (envVars != null) {
            for (Env item : envVars) {
                this.addToEnvVars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Env[] getEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnvVar(int index) {
        return this.envVars.get(index).build();
    }

    @Override
    public Env buildFirstEnvVar() {
        return this.envVars.get(0).build();
    }

    @Override
    public Env buildLastEnvVar() {
        return this.envVars.get(this.envVars.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.envVars.add(index >= 0 ? index : this.envVars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.envVars.size()) {
            this.envVars.add(builder);
        } else {
            this.envVars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvVars(Env ... items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvVars(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigEnvVars(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvVars() {
        return this.envVars != null && !this.envVars.isEmpty();
    }

    @Override
    public A addNewConfigEnvVar(String name, String value, String secret, String configmap, String field) {
        return this.addToEnvVars(new Env(name, value, secret, configmap, field));
    }

    @Override
    public CompositeConfigFluent.ConfigEnvVarsNested<A> addNewConfigEnvVar() {
        return new ConfigEnvVarsNestedImpl();
    }

    @Override
    public CompositeConfigFluent.ConfigEnvVarsNested<A> addNewEnvVarLike(Env item) {
        return new ConfigEnvVarsNestedImpl(-1, item);
    }

    @Override
    public CompositeConfigFluent.ConfigEnvVarsNested<A> setNewEnvVarLike(int index, Env item) {
        return new ConfigEnvVarsNestedImpl(index, item);
    }

    @Override
    public CompositeConfigFluent.ConfigEnvVarsNested<A> editEnvVar(int index) {
        if (this.envVars.size() <= index) {
            throw new RuntimeException("Can't edit envVars. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public CompositeConfigFluent.ConfigEnvVarsNested<A> editFirstEnvVar() {
        if (this.envVars.size() == 0) {
            throw new RuntimeException("Can't edit first envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    @Override
    public CompositeConfigFluent.ConfigEnvVarsNested<A> editLastEnvVar() {
        int index = this.envVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public CompositeConfigFluent.ConfigEnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVars.size(); ++i) {
            if (!predicate.apply((Object)this.envVars.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVars. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public A withLinks(Link ... links) {
        if (this.links != null) {
            this.links.clear();
        }
        if (links != null) {
            for (Link item : links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Link[] getLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link[] buildLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link buildLink(int index) {
        return this.links.get(index).build();
    }

    @Override
    public Link buildFirstLink() {
        return this.links.get(0).build();
    }

    @Override
    public Link buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    @Override
    public Link buildMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.links.add(index >= 0 ? index : this.links.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.links.size()) {
            this.links.add(builder);
        } else {
            this.links.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLinks(Link ... items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLinks(Collection<Link> items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(Link ... items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLinks(Collection<Link> items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> addNewLinkLike(Link item) {
        return new LinksNestedImpl(-1, item);
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> setNewLinkLike(int index, Link item) {
        return new LinksNestedImpl(index, item);
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editLink(int index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editMatchingLink(Predicate<LinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.apply((Object)this.links.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeConfigFluentImpl that = (CompositeConfigFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.deploymentType != null ? !this.deploymentType.equals((Object)that.deploymentType) : that.deploymentType != null) {
            return false;
        }
        if (this.exposeService != that.exposeService) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        return !(this.links != null ? !this.links.equals(that.links) : that.links != null);
    }

    public class LinksNestedImpl<N>
    extends LinkFluentImpl<CompositeConfigFluent.LinksNested<N>>
    implements CompositeConfigFluent.LinksNested<N>,
    Nested<N> {
        private final LinkBuilder builder;
        private final int index;

        LinksNestedImpl(int index, Link item) {
            this.index = index;
            this.builder = new LinkBuilder(this, item);
        }

        LinksNestedImpl() {
            this.index = -1;
            this.builder = new LinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)CompositeConfigFluentImpl.this.setToLinks(this.index, this.builder.build());
        }

        @Override
        public N endLink() {
            return this.and();
        }
    }

    public class ConfigEnvVarsNestedImpl<N>
    extends EnvFluentImpl<CompositeConfigFluent.ConfigEnvVarsNested<N>>
    implements CompositeConfigFluent.ConfigEnvVarsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        ConfigEnvVarsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder((EnvFluent)this, item);
        }

        ConfigEnvVarsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder((EnvFluent)this);
        }

        @Override
        public N and() {
            return (N)CompositeConfigFluentImpl.this.setToEnvVars(this.index, (Env)this.builder.build());
        }

        @Override
        public N endConfigEnvVar() {
            return this.and();
        }
    }
}

