/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.Storage;
import io.ap4k.component.model.StorageFluent;
import io.ap4k.component.model.StorageFluentImpl;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;

public class StorageBuilder
extends StorageFluentImpl<StorageBuilder>
implements VisitableBuilder<Storage, StorageBuilder> {
    StorageFluent<?> fluent;
    Boolean validationEnabled;

    public StorageBuilder() {
        this(true);
    }

    public StorageBuilder(Boolean validationEnabled) {
        this(new Storage(), validationEnabled);
    }

    public StorageBuilder(StorageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StorageBuilder(StorageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Storage(), validationEnabled);
    }

    public StorageBuilder(StorageFluent<?> fluent, Storage instance) {
        this(fluent, instance, true);
    }

    public StorageBuilder(StorageFluent<?> fluent, Storage instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withCapacity(instance.getCapacity());
        fluent.withMode(instance.getMode());
        this.validationEnabled = validationEnabled;
    }

    public StorageBuilder(Storage instance) {
        this(instance, (Boolean)true);
    }

    public StorageBuilder(Storage instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withCapacity(instance.getCapacity());
        this.withMode(instance.getMode());
        this.validationEnabled = validationEnabled;
    }

    public Storage build() {
        Storage buildable = new Storage(this.fluent.getName(), this.fluent.getCapacity(), this.fluent.getMode());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageBuilder that = (StorageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

