/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.ComponentSpec;
import io.ap4k.component.model.ComponentStatus;
import io.ap4k.deps.jackson.annotation.JsonIgnore;
import io.ap4k.deps.jackson.annotation.JsonInclude;
import io.ap4k.deps.jackson.annotation.JsonProperty;
import io.ap4k.deps.jackson.annotation.JsonPropertyOrder;
import io.ap4k.deps.jackson.databind.JsonDeserializer;
import io.ap4k.deps.jackson.databind.annotation.JsonDeserialize;
import io.ap4k.deps.javax.validation.Valid;
import io.ap4k.deps.javax.validation.constraints.NotNull;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.ObjectMeta;
import io.ap4k.deps.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Component
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "component.k8s.io/v1alpha1";
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "Component";
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max=253)
    private ObjectMeta metadata;
    @JsonProperty(value="spec")
    @Valid
    private ComponentSpec spec;
    @JsonProperty(value="status")
    @Valid
    private ComponentStatus status;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Component() {
    }

    public Component(String apiVersion, String kind, ObjectMeta metadata, ComponentSpec spec, ComponentStatus status, Map<String, Object> additionalProperties) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.metadata = metadata;
        this.spec = spec;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public ComponentSpec getSpec() {
        return this.spec;
    }

    public void setSpec(ComponentSpec spec) {
        this.spec = spec;
    }

    public ComponentStatus getStatus() {
        return this.status;
    }

    public void setStatus(ComponentStatus status) {
        this.status = status;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

