/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.processor;

import io.ap4k.Session;
import io.ap4k.component.adapt.CompositeConfigAdapter;
import io.ap4k.component.annotation.CompositeApplication;
import io.ap4k.component.config.CompositeConfig;
import io.ap4k.component.config.CompositeConfigBuilder;
import io.ap4k.component.handler.ComponentHandler;
import io.ap4k.component.handler.ComponentServiceCatalogHandler;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.ConfigurationSupplier;
import io.ap4k.processor.AbstractAnnotationProcessor;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Generate component custom resources.")
@SupportedAnnotationTypes(value={"io.ap4k.component.annotation.CompositeApplication"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CompositeAnnotationProcessor
extends AbstractAnnotationProcessor<CompositeConfig> {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Session session = Session.getSession();
        if (roundEnv.processingOver()) {
            session.onClose(arg_0 -> ((CompositeAnnotationProcessor)this).write(arg_0));
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                session.configurators().add(this.config(element));
                session.handlers().add(new ComponentHandler(session.resources()));
                session.handlers().add(new ComponentServiceCatalogHandler(session.resources()));
            }
        }
        return false;
    }

    public ConfigurationSupplier<CompositeConfig> config(Element mainClass) {
        CompositeApplication compositeApplication = mainClass.getAnnotation(CompositeApplication.class);
        return compositeApplication != null ? new ConfigurationSupplier((VisitableBuilder)CompositeConfigAdapter.newBuilder(compositeApplication)) : new ConfigurationSupplier((VisitableBuilder)new CompositeConfigBuilder());
    }
}

