/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.Parameter;
import io.ap4k.component.model.ParameterBuilder;
import io.ap4k.component.model.ParameterFluentImpl;
import io.ap4k.component.model.Service;
import io.ap4k.component.model.ServiceFluent;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceFluentImpl<A extends ServiceFluent<A>>
extends BaseFluent<A>
implements ServiceFluent<A> {
    private String name;
    private String serviceClass;
    private String servicePlan;
    private String externalId;
    private String secretName;
    private List<ParameterBuilder> parameters;
    private String parametersJson;

    public ServiceFluentImpl() {
    }

    public ServiceFluentImpl(Service instance) {
        this.withName(instance.getName());
        this.withServiceClass(instance.getServiceClass());
        this.withServicePlan(instance.getServicePlan());
        this.withExternalId(instance.getExternalId());
        this.withSecretName(instance.getSecretName());
        this.withParameters(instance.getParameters());
        this.withParametersJson(instance.getParametersJson());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public A withServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
        return (A)this;
    }

    @Override
    public Boolean hasServiceClass() {
        return this.serviceClass != null;
    }

    @Override
    public String getServicePlan() {
        return this.servicePlan;
    }

    @Override
    public A withServicePlan(String servicePlan) {
        this.servicePlan = servicePlan;
        return (A)this;
    }

    @Override
    public Boolean hasServicePlan() {
        return this.servicePlan != null;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public A withExternalId(String externalId) {
        this.externalId = externalId;
        return (A)this;
    }

    @Override
    public Boolean hasExternalId() {
        return this.externalId != null;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public A withParameters(Parameter ... parameters) {
        if (this.parameters != null) {
            this.parameters.clear();
        }
        if (parameters != null) {
            for (Parameter item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Parameter[] getParameters() {
        int size = this.parameters != null ? this.parameters.size() : 0;
        Parameter[] result = new Parameter[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.parameters) {
            result[index++] = (Parameter)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Parameter[] buildParameters() {
        int size = this.parameters != null ? this.parameters.size() : 0;
        Parameter[] result = new Parameter[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.parameters) {
            result[index++] = (Parameter)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Parameter buildParameter(int index) {
        return this.parameters.get(index).build();
    }

    @Override
    public Parameter buildFirstParameter() {
        return this.parameters.get(0).build();
    }

    @Override
    public Parameter buildLastParameter() {
        return this.parameters.get(this.parameters.size() - 1).build();
    }

    @Override
    public Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate) {
        for (ParameterBuilder item : this.parameters) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A addToParameters(int index, Parameter item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        ParameterBuilder builder = new ParameterBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.parameters.add(index >= 0 ? index : this.parameters.size(), builder);
        return (A)this;
    }

    @Override
    public A setToParameters(int index, Parameter item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        ParameterBuilder builder = new ParameterBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.parameters.size()) {
            this.parameters.add(builder);
        } else {
            this.parameters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToParameters(Parameter ... items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.add(builder);
            this.parameters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToParameters(Collection<Parameter> items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.add(builder);
            this.parameters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(Parameter ... items) {
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.remove(builder);
            if (this.parameters == null) continue;
            this.parameters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromParameters(Collection<Parameter> items) {
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.remove(builder);
            if (this.parameters == null) continue;
            this.parameters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    @Override
    public A addNewParameter(String name, String value) {
        return this.addToParameters(new Parameter(name, value));
    }

    @Override
    public ServiceFluent.ParametersNested<A> addNewParameter() {
        return new ParametersNestedImpl();
    }

    @Override
    public ServiceFluent.ParametersNested<A> addNewParameterLike(Parameter item) {
        return new ParametersNestedImpl(-1, item);
    }

    @Override
    public ServiceFluent.ParametersNested<A> setNewParameterLike(int index, Parameter item) {
        return new ParametersNestedImpl(index, item);
    }

    @Override
    public ServiceFluent.ParametersNested<A> editParameter(int index) {
        if (this.parameters.size() <= index) {
            throw new RuntimeException("Can't edit parameters. Index exceeds size.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public ServiceFluent.ParametersNested<A> editFirstParameter() {
        if (this.parameters.size() == 0) {
            throw new RuntimeException("Can't edit first parameters. The list is empty.");
        }
        return this.setNewParameterLike(0, this.buildParameter(0));
    }

    @Override
    public ServiceFluent.ParametersNested<A> editLastParameter() {
        int index = this.parameters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parameters. The list is empty.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public ServiceFluent.ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!predicate.apply((Object)this.parameters.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parameters. No match found.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public String getParametersJson() {
        return this.parametersJson;
    }

    @Override
    public A withParametersJson(String parametersJson) {
        this.parametersJson = parametersJson;
        return (A)this;
    }

    @Override
    public Boolean hasParametersJson() {
        return this.parametersJson != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceFluentImpl that = (ServiceFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.serviceClass != null ? !this.serviceClass.equals(that.serviceClass) : that.serviceClass != null) {
            return false;
        }
        if (this.servicePlan != null ? !this.servicePlan.equals(that.servicePlan) : that.servicePlan != null) {
            return false;
        }
        if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) {
            return false;
        }
        if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.parametersJson != null ? !this.parametersJson.equals(that.parametersJson) : that.parametersJson != null);
    }

    public class ParametersNestedImpl<N>
    extends ParameterFluentImpl<ServiceFluent.ParametersNested<N>>
    implements ServiceFluent.ParametersNested<N>,
    Nested<N> {
        private final ParameterBuilder builder;
        private final int index;

        ParametersNestedImpl(int index, Parameter item) {
            this.index = index;
            this.builder = new ParameterBuilder(this, item);
        }

        ParametersNestedImpl() {
            this.index = -1;
            this.builder = new ParameterBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceFluentImpl.this.setToParameters(this.index, this.builder.build());
        }

        @Override
        public N endParameter() {
            return this.and();
        }
    }
}

