/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.ComponentSpec;
import io.ap4k.component.model.ComponentSpecFluent;
import io.ap4k.component.model.DeploymentType;
import io.ap4k.component.model.Env;
import io.ap4k.component.model.EnvBuilder;
import io.ap4k.component.model.EnvFluentImpl;
import io.ap4k.component.model.Feature;
import io.ap4k.component.model.FeatureBuilder;
import io.ap4k.component.model.FeatureFluentImpl;
import io.ap4k.component.model.Image;
import io.ap4k.component.model.ImageBuilder;
import io.ap4k.component.model.ImageFluentImpl;
import io.ap4k.component.model.Link;
import io.ap4k.component.model.LinkBuilder;
import io.ap4k.component.model.LinkFluentImpl;
import io.ap4k.component.model.Service;
import io.ap4k.component.model.ServiceBuilder;
import io.ap4k.component.model.ServiceFluentImpl;
import io.ap4k.component.model.Storage;
import io.ap4k.component.model.StorageBuilder;
import io.ap4k.component.model.StorageFluentImpl;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentSpecFluentImpl<A extends ComponentSpecFluent<A>>
extends BaseFluent<A>
implements ComponentSpecFluent<A> {
    private String name;
    private String packagingMode;
    private String type;
    private DeploymentType deploymentMode;
    private String runtime;
    private String version;
    private boolean exposeService;
    private String cpu;
    private StorageBuilder storage;
    private List<ImageBuilder> images;
    private List<EnvBuilder> envs;
    private List<ServiceBuilder> services;
    private List<FeatureBuilder> features;
    private List<LinkBuilder> links;

    public ComponentSpecFluentImpl() {
    }

    public ComponentSpecFluentImpl(ComponentSpec instance) {
        this.withName(instance.getName());
        this.withPackagingMode(instance.getPackagingMode());
        this.withType(instance.getType());
        this.withDeploymentMode(instance.getDeploymentMode());
        this.withRuntime(instance.getRuntime());
        this.withVersion(instance.getVersion());
        this.withExposeService(instance.isExposeService());
        this.withCpu(instance.getCpu());
        this.withStorage(instance.getStorage());
        this.withImages(instance.getImages());
        this.withEnvs(instance.getEnvs());
        this.withServices(instance.getServices());
        this.withFeatures(instance.getFeatures());
        this.withLinks(instance.getLinks());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getPackagingMode() {
        return this.packagingMode;
    }

    @Override
    public A withPackagingMode(String packagingMode) {
        this.packagingMode = packagingMode;
        return (A)this;
    }

    @Override
    public Boolean hasPackagingMode() {
        return this.packagingMode != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public DeploymentType getDeploymentMode() {
        return this.deploymentMode;
    }

    @Override
    public A withDeploymentMode(DeploymentType deploymentMode) {
        this.deploymentMode = deploymentMode;
        return (A)this;
    }

    @Override
    public Boolean hasDeploymentMode() {
        return this.deploymentMode != null;
    }

    @Override
    public String getRuntime() {
        return this.runtime;
    }

    @Override
    public A withRuntime(String runtime) {
        this.runtime = runtime;
        return (A)this;
    }

    @Override
    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public boolean isExposeService() {
        return this.exposeService;
    }

    @Override
    public A withExposeService(boolean exposeService) {
        this.exposeService = exposeService;
        return (A)this;
    }

    @Override
    public Boolean hasExposeService() {
        return true;
    }

    @Override
    public String getCpu() {
        return this.cpu;
    }

    @Override
    public A withCpu(String cpu) {
        this.cpu = cpu;
        return (A)this;
    }

    @Override
    public Boolean hasCpu() {
        return this.cpu != null;
    }

    @Override
    @Deprecated
    public Storage getStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public Storage buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public A withStorage(Storage storage) {
        this._visitables.remove(this.storage);
        if (storage != null) {
            this.storage = new StorageBuilder(storage);
            this._visitables.add(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public A withNewStorage(String name, String capacity, String mode) {
        return this.withStorage(new Storage(name, capacity, mode));
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> withNewStorage() {
        return new StorageNestedImpl();
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> withNewStorageLike(Storage item) {
        return new StorageNestedImpl(item);
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> editStorage() {
        return this.withNewStorageLike(this.getStorage());
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : new StorageBuilder().build());
    }

    @Override
    public ComponentSpecFluent.StorageNested<A> editOrNewStorageLike(Storage item) {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : item);
    }

    @Override
    public A withImages(Image ... images) {
        if (this.images != null) {
            this.images.clear();
        }
        if (images != null) {
            for (Image item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Image[] getImages() {
        int size = this.images != null ? this.images.size() : 0;
        Image[] result = new Image[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.images) {
            result[index++] = (Image)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Image[] buildImages() {
        int size = this.images != null ? this.images.size() : 0;
        Image[] result = new Image[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.images) {
            result[index++] = (Image)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Image buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public Image buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public Image buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public Image buildMatchingImage(Predicate<ImageBuilder> predicate) {
        for (ImageBuilder item : this.images) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A addToImages(int index, Image item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageBuilder>();
        }
        ImageBuilder builder = new ImageBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.images.add(index >= 0 ? index : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(int index, Image item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageBuilder>();
        }
        ImageBuilder builder = new ImageBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(Image ... items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageBuilder>();
        }
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<Image> items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageBuilder>();
        }
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(Image ... items) {
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<Image> items) {
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public A addNewImage(String name, boolean annotationCmds, String repo, String tag, String dockerImage) {
        return this.addToImages(new Image(name, annotationCmds, repo, tag, dockerImage));
    }

    @Override
    public ComponentSpecFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public ComponentSpecFluent.ImagesNested<A> addNewImageLike(Image item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public ComponentSpecFluent.ImagesNested<A> setNewImageLike(int index, Image item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public ComponentSpecFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ComponentSpecFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public ComponentSpecFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ComponentSpecFluent.ImagesNested<A> editMatchingImage(Predicate<ImageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.apply((Object)this.images.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public A withEnvs(Env ... envs) {
        if (this.envs != null) {
            this.envs.clear();
        }
        if (envs != null) {
            for (Env item : envs) {
                this.addToEnvs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Env[] getEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvs() {
        int size = this.envs != null ? this.envs.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envs) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnv(int index) {
        return this.envs.get(index).build();
    }

    @Override
    public Env buildFirstEnv() {
        return this.envs.get(0).build();
    }

    @Override
    public Env buildLastEnv() {
        return this.envs.get(this.envs.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A addToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.envs.add(index >= 0 ? index : this.envs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvs(int index, Env item) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.envs.size()) {
            this.envs.add(builder);
        } else {
            this.envs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvs(Env ... items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvs(Collection<Env> items) {
        if (this.envs == null) {
            this.envs = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvs(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvs(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envs == null) continue;
            this.envs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvs() {
        return this.envs != null && !this.envs.isEmpty();
    }

    @Override
    public A addNewEnv(String name, String value) {
        return this.addToEnvs(new Env(name, value));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> addNewEnv() {
        return new EnvsNestedImpl();
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> addNewEnvLike(Env item) {
        return new EnvsNestedImpl(-1, item);
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> setNewEnvLike(int index, Env item) {
        return new EnvsNestedImpl(index, item);
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editEnv(int index) {
        if (this.envs.size() <= index) {
            throw new RuntimeException("Can't edit envs. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editFirstEnv() {
        if (this.envs.size() == 0) {
            throw new RuntimeException("Can't edit first envs. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editLastEnv() {
        int index = this.envs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envs. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ComponentSpecFluent.EnvsNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envs.size(); ++i) {
            if (!predicate.apply((Object)this.envs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envs. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public A withServices(Service ... services) {
        if (this.services != null) {
            this.services.clear();
        }
        if (services != null) {
            for (Service item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Service[] getServices() {
        int size = this.services != null ? this.services.size() : 0;
        Service[] result = new Service[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (Service)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Service[] buildServices() {
        int size = this.services != null ? this.services.size() : 0;
        Service[] result = new Service[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (Service)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Service buildService(int index) {
        return this.services.get(index).build();
    }

    @Override
    public Service buildFirstService() {
        return this.services.get(0).build();
    }

    @Override
    public Service buildLastService() {
        return this.services.get(this.services.size() - 1).build();
    }

    @Override
    public Service buildMatchingService(Predicate<ServiceBuilder> predicate) {
        for (ServiceBuilder item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A addToServices(int index, Service item) {
        if (this.services == null) {
            this.services = new ArrayList<ServiceBuilder>();
        }
        ServiceBuilder builder = new ServiceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.services.add(index >= 0 ? index : this.services.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServices(int index, Service item) {
        if (this.services == null) {
            this.services = new ArrayList<ServiceBuilder>();
        }
        ServiceBuilder builder = new ServiceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.services.size()) {
            this.services.add(builder);
        } else {
            this.services.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServices(Service ... items) {
        if (this.services == null) {
            this.services = new ArrayList<ServiceBuilder>();
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.add(builder);
            this.services.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<Service> items) {
        if (this.services == null) {
            this.services = new ArrayList<ServiceBuilder>();
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.add(builder);
            this.services.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(Service ... items) {
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.remove(builder);
            if (this.services == null) continue;
            this.services.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<Service> items) {
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.remove(builder);
            if (this.services == null) continue;
            this.services.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    @Override
    public ComponentSpecFluent.ServicesNested<A> addNewService() {
        return new ServicesNestedImpl();
    }

    @Override
    public ComponentSpecFluent.ServicesNested<A> addNewServiceLike(Service item) {
        return new ServicesNestedImpl(-1, item);
    }

    @Override
    public ComponentSpecFluent.ServicesNested<A> setNewServiceLike(int index, Service item) {
        return new ServicesNestedImpl(index, item);
    }

    @Override
    public ComponentSpecFluent.ServicesNested<A> editService(int index) {
        if (this.services.size() <= index) {
            throw new RuntimeException("Can't edit services. Index exceeds size.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public ComponentSpecFluent.ServicesNested<A> editFirstService() {
        if (this.services.size() == 0) {
            throw new RuntimeException("Can't edit first services. The list is empty.");
        }
        return this.setNewServiceLike(0, this.buildService(0));
    }

    @Override
    public ComponentSpecFluent.ServicesNested<A> editLastService() {
        int index = this.services.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last services. The list is empty.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public ComponentSpecFluent.ServicesNested<A> editMatchingService(Predicate<ServiceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.services.size(); ++i) {
            if (!predicate.apply((Object)this.services.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching services. No match found.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public A withFeatures(Feature ... features) {
        if (this.features != null) {
            this.features.clear();
        }
        if (features != null) {
            for (Feature item : features) {
                this.addToFeatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public Feature[] getFeatures() {
        int size = this.features != null ? this.features.size() : 0;
        Feature[] result = new Feature[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.features) {
            result[index++] = (Feature)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Feature[] buildFeatures() {
        int size = this.features != null ? this.features.size() : 0;
        Feature[] result = new Feature[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.features) {
            result[index++] = (Feature)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Feature buildFeature(int index) {
        return this.features.get(index).build();
    }

    @Override
    public Feature buildFirstFeature() {
        return this.features.get(0).build();
    }

    @Override
    public Feature buildLastFeature() {
        return this.features.get(this.features.size() - 1).build();
    }

    @Override
    public Feature buildMatchingFeature(Predicate<FeatureBuilder> predicate) {
        for (FeatureBuilder item : this.features) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A addToFeatures(int index, Feature item) {
        if (this.features == null) {
            this.features = new ArrayList<FeatureBuilder>();
        }
        FeatureBuilder builder = new FeatureBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.features.add(index >= 0 ? index : this.features.size(), builder);
        return (A)this;
    }

    @Override
    public A setToFeatures(int index, Feature item) {
        if (this.features == null) {
            this.features = new ArrayList<FeatureBuilder>();
        }
        FeatureBuilder builder = new FeatureBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.features.size()) {
            this.features.add(builder);
        } else {
            this.features.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFeatures(Feature ... items) {
        if (this.features == null) {
            this.features = new ArrayList<FeatureBuilder>();
        }
        for (Feature item : items) {
            FeatureBuilder builder = new FeatureBuilder(item);
            this._visitables.add(builder);
            this.features.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFeatures(Collection<Feature> items) {
        if (this.features == null) {
            this.features = new ArrayList<FeatureBuilder>();
        }
        for (Feature item : items) {
            FeatureBuilder builder = new FeatureBuilder(item);
            this._visitables.add(builder);
            this.features.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFeatures(Feature ... items) {
        for (Feature item : items) {
            FeatureBuilder builder = new FeatureBuilder(item);
            this._visitables.remove(builder);
            if (this.features == null) continue;
            this.features.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFeatures(Collection<Feature> items) {
        for (Feature item : items) {
            FeatureBuilder builder = new FeatureBuilder(item);
            this._visitables.remove(builder);
            if (this.features == null) continue;
            this.features.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFeatures() {
        return this.features != null && !this.features.isEmpty();
    }

    @Override
    public A addNewFeature(String id, String name, String description) {
        return this.addToFeatures(new Feature(id, name, description));
    }

    @Override
    public ComponentSpecFluent.FeaturesNested<A> addNewFeature() {
        return new FeaturesNestedImpl();
    }

    @Override
    public ComponentSpecFluent.FeaturesNested<A> addNewFeatureLike(Feature item) {
        return new FeaturesNestedImpl(-1, item);
    }

    @Override
    public ComponentSpecFluent.FeaturesNested<A> setNewFeatureLike(int index, Feature item) {
        return new FeaturesNestedImpl(index, item);
    }

    @Override
    public ComponentSpecFluent.FeaturesNested<A> editFeature(int index) {
        if (this.features.size() <= index) {
            throw new RuntimeException("Can't edit features. Index exceeds size.");
        }
        return this.setNewFeatureLike(index, this.buildFeature(index));
    }

    @Override
    public ComponentSpecFluent.FeaturesNested<A> editFirstFeature() {
        if (this.features.size() == 0) {
            throw new RuntimeException("Can't edit first features. The list is empty.");
        }
        return this.setNewFeatureLike(0, this.buildFeature(0));
    }

    @Override
    public ComponentSpecFluent.FeaturesNested<A> editLastFeature() {
        int index = this.features.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last features. The list is empty.");
        }
        return this.setNewFeatureLike(index, this.buildFeature(index));
    }

    @Override
    public ComponentSpecFluent.FeaturesNested<A> editMatchingFeature(Predicate<FeatureBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.features.size(); ++i) {
            if (!predicate.apply((Object)this.features.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching features. No match found.");
        }
        return this.setNewFeatureLike(index, this.buildFeature(index));
    }

    @Override
    public A withLinks(Link ... links) {
        if (this.links != null) {
            this.links.clear();
        }
        if (links != null) {
            for (Link item : links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Link[] getLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link[] buildLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link buildLink(int index) {
        return this.links.get(index).build();
    }

    @Override
    public Link buildFirstLink() {
        return this.links.get(0).build();
    }

    @Override
    public Link buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    @Override
    public Link buildMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A addToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.links.add(index >= 0 ? index : this.links.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.links.size()) {
            this.links.add(builder);
        } else {
            this.links.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLinks(Link ... items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLinks(Collection<Link> items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(Link ... items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLinks(Collection<Link> items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    @Override
    public ComponentSpecFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    @Override
    public ComponentSpecFluent.LinksNested<A> addNewLinkLike(Link item) {
        return new LinksNestedImpl(-1, item);
    }

    @Override
    public ComponentSpecFluent.LinksNested<A> setNewLinkLike(int index, Link item) {
        return new LinksNestedImpl(index, item);
    }

    @Override
    public ComponentSpecFluent.LinksNested<A> editLink(int index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public ComponentSpecFluent.LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    @Override
    public ComponentSpecFluent.LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public ComponentSpecFluent.LinksNested<A> editMatchingLink(Predicate<LinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.apply((Object)this.links.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentSpecFluentImpl that = (ComponentSpecFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.packagingMode != null ? !this.packagingMode.equals(that.packagingMode) : that.packagingMode != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.deploymentMode != null ? !this.deploymentMode.equals((Object)that.deploymentMode) : that.deploymentMode != null) {
            return false;
        }
        if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.exposeService != that.exposeService) {
            return false;
        }
        if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) {
            return false;
        }
        if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.envs != null ? !this.envs.equals(that.envs) : that.envs != null) {
            return false;
        }
        if (this.services != null ? !this.services.equals(that.services) : that.services != null) {
            return false;
        }
        if (this.features != null ? !this.features.equals(that.features) : that.features != null) {
            return false;
        }
        return !(this.links != null ? !this.links.equals(that.links) : that.links != null);
    }

    public class LinksNestedImpl<N>
    extends LinkFluentImpl<ComponentSpecFluent.LinksNested<N>>
    implements ComponentSpecFluent.LinksNested<N>,
    Nested<N> {
        private final LinkBuilder builder;
        private final int index;

        LinksNestedImpl(int index, Link item) {
            this.index = index;
            this.builder = new LinkBuilder(this, item);
        }

        LinksNestedImpl() {
            this.index = -1;
            this.builder = new LinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.setToLinks(this.index, this.builder.build());
        }

        @Override
        public N endLink() {
            return this.and();
        }
    }

    public class FeaturesNestedImpl<N>
    extends FeatureFluentImpl<ComponentSpecFluent.FeaturesNested<N>>
    implements ComponentSpecFluent.FeaturesNested<N>,
    Nested<N> {
        private final FeatureBuilder builder;
        private final int index;

        FeaturesNestedImpl(int index, Feature item) {
            this.index = index;
            this.builder = new FeatureBuilder(this, item);
        }

        FeaturesNestedImpl() {
            this.index = -1;
            this.builder = new FeatureBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.setToFeatures(this.index, this.builder.build());
        }

        @Override
        public N endFeature() {
            return this.and();
        }
    }

    public class ServicesNestedImpl<N>
    extends ServiceFluentImpl<ComponentSpecFluent.ServicesNested<N>>
    implements ComponentSpecFluent.ServicesNested<N>,
    Nested<N> {
        private final ServiceBuilder builder;
        private final int index;

        ServicesNestedImpl(int index, Service item) {
            this.index = index;
            this.builder = new ServiceBuilder(this, item);
        }

        ServicesNestedImpl() {
            this.index = -1;
            this.builder = new ServiceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.setToServices(this.index, this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }

    public class EnvsNestedImpl<N>
    extends EnvFluentImpl<ComponentSpecFluent.EnvsNested<N>>
    implements ComponentSpecFluent.EnvsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        EnvsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        EnvsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.setToEnvs(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ImageFluentImpl<ComponentSpecFluent.ImagesNested<N>>
    implements ComponentSpecFluent.ImagesNested<N>,
    Nested<N> {
        private final ImageBuilder builder;
        private final int index;

        ImagesNestedImpl(int index, Image item) {
            this.index = index;
            this.builder = new ImageBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class StorageNestedImpl<N>
    extends StorageFluentImpl<ComponentSpecFluent.StorageNested<N>>
    implements ComponentSpecFluent.StorageNested<N>,
    Nested<N> {
        private final StorageBuilder builder;

        StorageNestedImpl(Storage item) {
            this.builder = new StorageBuilder(this, item);
        }

        StorageNestedImpl() {
            this.builder = new StorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentSpecFluentImpl.this.withStorage(this.builder.build());
        }

        @Override
        public N endStorage() {
            return this.and();
        }
    }
}

